/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistBackupWriteResponseTest")
public class DistServerBackupWriteResponseTest
extends BaseDistFunctionalTest<Object, String> {
    @Override
    protected void createClusteredCache() {
        SerializationContextInitializer sci = this.getSerializationContext();
        GlobalConfigurationBuilder globalBuilder = this.defaultGlobalConfigurationBuilder();
        if (sci != null) {
            globalBuilder.serialization().addContextInitializer(sci);
        }
        this.configuration.encoding().mediaType(MediaType.APPLICATION_OBJECT);
        this.createClusteredCaches(this.INIT_CLUSTER_SIZE, globalBuilder, this.configuration, true, new TransportFlags().withFD(false), this.cacheName);
    }

    public void testRemoveBackupResponseContainsNoValues() {
        MagicKey key = this.getKeyForCache(this.c1, this.c2);
        this.c1.put((Object)key, (Object)"value");
        EmbeddedCacheManager cm = this.manager(0);
        JGroupsTransport actualTransport = (JGroupsTransport)TestingUtil.extractGlobalComponent((CacheContainer)cm, Transport.class);
        RequestRepository requestRepository = (RequestRepository)TestingUtil.extractField(actualTransport, "requests");
        RequestRepository spy = (RequestRepository)Mockito.spy((Object)requestRepository);
        TestingUtil.replaceField(spy, "requests", actualTransport, JGroupsTransport.class);
        AssertJUnit.assertEquals((String)"value", (String)((String)this.c1.remove((Object)key)));
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((RequestRepository)Mockito.verify((Object)spy)).addResponse(Mockito.anyLong(), (Address)Mockito.any(), (Response)responseCaptor.capture());
        Response response = (Response)responseCaptor.getValue();
        AssertJUnit.assertTrue((boolean)(response instanceof SuccessfulResponse));
        AssertJUnit.assertNull((Object)((SuccessfulResponse)response).getResponseValue());
    }
}

