/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.resources;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.AbstractResource;
import org.infinispan.cli.resources.CachesResource;
import org.infinispan.cli.resources.ConfigurationsResource;
import org.infinispan.cli.resources.ContainersResource;
import org.infinispan.cli.resources.CountersResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.resources.SchemasResource;
import org.infinispan.cli.resources.TasksResource;

public class ContainerResource
extends AbstractResource {
    ContainerResource(ContainersResource parent, String name) {
        super(parent, name);
    }

    @Override
    public Iterable<String> getChildrenNames() {
        return Arrays.asList("caches", "counters", "configurations", "schemas", "tasks");
    }

    @Override
    public Resource getChild(String name) {
        return switch (name) {
            case ".." -> this.parent;
            case "caches" -> new CachesResource(this);
            case "counters" -> new CountersResource(this);
            case "configurations" -> new ConfigurationsResource(this);
            case "schemas" -> new SchemasResource(this);
            case "tasks" -> new TasksResource(this);
            default -> throw Messages.MSG.noSuchResource(name);
        };
    }

    @Override
    public String describe() throws IOException {
        return this.getConnection().describeContainer();
    }

    public static Optional<String> findContainerName(Resource resource) {
        return resource.optionalFindAncestor(ContainerResource.class).map(AbstractResource::getName);
    }
}

