/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.actions;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class ConstructorInstance {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private ConstructorInstance() {
    }

    public static <T> T action(Constructor<T> constructor, Object ... initArgs) {
        try {
            return constructor.newInstance(initArgs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw LOG.getUnableToInstantiateException(constructor.getDeclaringClass(), e);
        }
    }
}

