/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.resolver;

import jakarta.validation.TraversableResolver;
import jakarta.validation.ValidationException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.hibernate.validator.internal.engine.resolver.CachingJPATraversableResolverForSingleValidation;
import org.hibernate.validator.internal.engine.resolver.CachingTraversableResolverForSingleValidation;
import org.hibernate.validator.internal.engine.resolver.TraverseAllTraversableResolver;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.actions.GetMethod;
import org.hibernate.validator.internal.util.actions.LoadClass;
import org.hibernate.validator.internal.util.actions.NewInstance;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class TraversableResolvers {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final String PERSISTENCE_CLASS_NAME = "jakarta.persistence.Persistence";
    private static final String PERSISTENCE_UTIL_METHOD = "getPersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME = "org.hibernate.validator.internal.engine.resolver.JPATraversableResolver";

    private TraversableResolvers() {
    }

    public static TraversableResolver getDefault() {
        Class<?> persistenceClass;
        try {
            persistenceClass = LoadClass.action(PERSISTENCE_CLASS_NAME, TraversableResolvers.class.getClassLoader());
        }
        catch (ValidationException e) {
            LOG.debugf("Cannot find %s on classpath. Assuming non Jakarta Persistence environment. All properties will per default be traversable.", PERSISTENCE_CLASS_NAME);
            return TraversableResolvers.getTraverseAllTraversableResolver();
        }
        Method persistenceUtilGetter = GetMethod.action(persistenceClass, PERSISTENCE_UTIL_METHOD);
        if (persistenceUtilGetter == null) {
            LOG.debugf("Found %s on classpath, but no method '%s'. Assuming JPA 1 environment. All properties will per default be traversable.", PERSISTENCE_CLASS_NAME, PERSISTENCE_UTIL_METHOD);
            return TraversableResolvers.getTraverseAllTraversableResolver();
        }
        try {
            Object persistence = NewInstance.action(persistenceClass, "persistence provider");
            ReflectionHelper.getValue(persistenceUtilGetter, persistence);
        }
        catch (Exception e) {
            LOG.debugf("Unable to invoke %s.%s. Inconsistent Jakarta Persistence environment. All properties will per default be traversable.", PERSISTENCE_CLASS_NAME, PERSISTENCE_UTIL_METHOD);
            return TraversableResolvers.getTraverseAllTraversableResolver();
        }
        LOG.debugf("Found %s on classpath containing '%s'. Assuming Jakarta Persistence environment. Trying to instantiate Jakarta Persistence aware TraversableResolver", PERSISTENCE_CLASS_NAME, PERSISTENCE_UTIL_METHOD);
        try {
            Class<?> jpaAwareResolverClass = LoadClass.action(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME, TraversableResolvers.class.getClassLoader());
            LOG.debugf("Instantiated Jakarta Persistence aware TraversableResolver of type %s.", JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
            return (TraversableResolver)NewInstance.action(jpaAwareResolverClass, "");
        }
        catch (ValidationException e) {
            LOG.logUnableToLoadOrInstantiateJPAAwareResolver(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
            return TraversableResolvers.getTraverseAllTraversableResolver();
        }
    }

    public static TraversableResolver wrapWithCachingForSingleValidation(TraversableResolver traversableResolver, boolean traversableResolverResultCacheEnabled) {
        if (TraverseAllTraversableResolver.class.equals((Object)traversableResolver.getClass()) || !traversableResolverResultCacheEnabled) {
            return traversableResolver;
        }
        if (JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME.equals(traversableResolver.getClass().getName())) {
            return new CachingJPATraversableResolverForSingleValidation(traversableResolver);
        }
        return new CachingTraversableResolverForSingleValidation(traversableResolver);
    }

    private static TraversableResolver getTraverseAllTraversableResolver() {
        return new TraverseAllTraversableResolver();
    }
}

