/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.util.Counter;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneCounterAdapter;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public abstract class HibernateSearchMultiCollectorManager
implements CollectorManager<Collector, MultiCollectedResults> {
    private final TimeoutManager timeoutManager;

    protected HibernateSearchMultiCollectorManager(TimeoutManager timeoutManager) {
        this.timeoutManager = timeoutManager;
    }

    public static HibernateSearchMultiCollectorManager create(TimeoutManager timeoutManager, Map<CollectorKey<?, ?>, CollectorManager<Collector, ?>> collectorManagers) {
        if (collectorManagers.size() == 1) {
            Map.Entry<CollectorKey<?, ?>, CollectorManager<Collector, ?>> entry = collectorManagers.entrySet().iterator().next();
            return new HibernateSearchMultiCollectorManagerSingle(timeoutManager, entry.getKey(), entry.getValue());
        }
        return new HibernateSearchMultiCollectorManagerMulti(timeoutManager, collectorManagers);
    }

    public HibernateSearchQueryTimeout queryTimeout() {
        Deadline deadline = this.timeoutManager.deadlineOrNull();
        if (deadline != null) {
            return new HibernateSearchQueryTimeout(this.timeoutManager, deadline);
        }
        return null;
    }

    private static class HibernateSearchMultiCollectorManagerSingle
    extends HibernateSearchMultiCollectorManager {
        private final CollectorKey<?, ?> key;
        private final CollectorManager<Collector, ?> collectorManager;

        private HibernateSearchMultiCollectorManagerSingle(TimeoutManager timeoutManager, CollectorKey<?, ?> key, CollectorManager<Collector, ?> collectorManager) {
            super(timeoutManager);
            this.key = key;
            this.collectorManager = collectorManager;
        }

        public Collector newCollector() throws IOException {
            return this.collectorManager.newCollector();
        }

        public MultiCollectedResults reduce(Collection<Collector> collectors) throws IOException {
            return new MultiCollectedResults(Collections.singletonMap(this.key, this.collectorManager.reduce(collectors)));
        }
    }

    private static class HibernateSearchMultiCollectorManagerMulti
    extends HibernateSearchMultiCollectorManager {
        private final Map<CollectorKey<?, ?>, CollectorManager<Collector, ?>> collectorManagers;

        private HibernateSearchMultiCollectorManagerMulti(TimeoutManager timeoutManager, Map<CollectorKey<?, ?>, CollectorManager<Collector, ?>> collectorManagers) {
            super(timeoutManager);
            this.collectorManagers = collectorManagers;
        }

        public Collector newCollector() throws IOException {
            Collector[] collectors = new Collector[this.collectorManagers.size()];
            int i = 0;
            for (CollectorManager<Collector, ?> collectorManager : this.collectorManagers.values()) {
                collectors[i++] = collectorManager.newCollector();
            }
            return MultiCollector.wrap((Collector[])collectors);
        }

        public MultiCollectedResults reduce(Collection<Collector> collectors) throws IOException {
            int size = collectors.size();
            HashMap results = new HashMap();
            int i = 0;
            for (Map.Entry<CollectorKey<?, ?>, CollectorManager<Collector, ?>> entry : this.collectorManagers.entrySet()) {
                ArrayList<Collector> toReduce = new ArrayList<Collector>(size);
                for (Collector collector : collectors) {
                    toReduce.add(((MultiCollector)collector).getCollectors()[i]);
                }
                results.put(entry.getKey(), entry.getValue().reduce(toReduce));
                ++i;
            }
            return new MultiCollectedResults(results);
        }
    }

    public static final class HibernateSearchQueryTimeout
    implements QueryTimeout {
        private final Deadline deadline;
        private final Counter clock;
        private final long baseline;
        private final long timeout;
        private boolean reached = false;

        public HibernateSearchQueryTimeout(TimeoutManager timeoutManager, Deadline deadline) {
            this.deadline = deadline;
            this.clock = new LuceneCounterAdapter(timeoutManager.timingSource());
            this.baseline = timeoutManager.timeoutBaseline();
            this.timeout = this.baseline + deadline.checkRemainingTimeMillis();
        }

        public boolean isReached() {
            return this.reached;
        }

        public boolean shouldExit() {
            if (this.clock.get() > this.timeout) {
                this.reached = true;
                this.deadline.forceTimeout(null);
                return true;
            }
            return false;
        }
    }

    public static class Builder {
        private final CollectorExecutionContext executionContext;
        private final TimeoutManager timeoutManager;
        private final Map<CollectorKey<?, ?>, CollectorManager<Collector, ?>> components = new LinkedHashMap();

        public Builder(CollectorExecutionContext executionContext, TimeoutManager timeoutManager) {
            this.executionContext = executionContext;
            this.timeoutManager = timeoutManager;
        }

        public <C extends Collector, T> void add(CollectorKey<C, T> key, CollectorManager<? extends Collector, ? extends T> collectorManager) {
            this.components.put(key, collectorManager);
        }

        public void addAll(Set<CollectorFactory<?, ?, ?>> collectorFactories) throws IOException {
            for (CollectorFactory<?, ?, ?> collectorFactory : collectorFactories) {
                this.add(collectorFactory);
            }
        }

        public <C extends Collector, T, CM extends CollectorManager<C, T>> void add(CollectorFactory<C, T, CM> collectorFactory) throws IOException {
            CM collectorManager = collectorFactory.createCollectorManager(this.executionContext);
            this.components.put(collectorFactory.getCollectorKey(), (CollectorManager<Collector, ?>)collectorManager);
        }

        public HibernateSearchMultiCollectorManager build() {
            if (this.components.isEmpty()) {
                return null;
            }
            return HibernateSearchMultiCollectorManager.create(this.timeoutManager, this.components);
        }
    }

    public static class MultiCollectedResults {
        public static final MultiCollectedResults EMPTY = new MultiCollectedResults(Collections.emptyMap());
        private final Map<CollectorKey<?, ?>, Object> results;

        public MultiCollectedResults(Map<CollectorKey<?, ?>, Object> results) {
            this.results = results;
        }

        public <C extends Collector, T> T get(CollectorKey<C, T> key) {
            return (T)this.results.get(key);
        }
    }
}

