/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.lowlevel.collector.impl.DocumentReferenceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.EntityProjectionBuilder;

public class LuceneEntityProjection<E>
extends AbstractLuceneProjection<Object, E> {
    private LuceneEntityProjection(LuceneSearchContext searchContext) {
        super(searchContext);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        context.requireCollector(DocumentReferenceCollector.FACTORY);
    }

    @Override
    public Object extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        DocumentReference documentReference = context.getCollector(DocumentReferenceCollector.KEY).get(documentResult.getDocId());
        return mapper.planLoading(documentReference);
    }

    @Override
    public E transform(LoadingResult<?, ?> loadingResult, Object extractedData, SearchProjectionTransformContext context) {
        Object loaded = loadingResult.get(extractedData);
        if (loaded == null) {
            context.reportFailedLoad();
        }
        return (E)loaded;
    }

    public static class Builder<E>
    extends AbstractLuceneProjection.AbstractBuilder<E>
    implements EntityProjectionBuilder<E> {
        public Builder(LuceneSearchContext searchContext) {
            super(searchContext);
        }

        public SearchProjection<E> build() {
            return new LuceneEntityProjection(this.searchContext);
        }
    }
}

