/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.function.DoubleToLongFunction;
import java.util.function.LongToDoubleFunction;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;

public abstract class NumericDoubleValues
extends DoubleValues {
    public static final NumericDoubleValues EMPTY = new NumericDoubleValues(){

        public double doubleValue() {
            throw new UnsupportedOperationException();
        }

        public boolean advanceExact(int doc) {
            return false;
        }
    };

    protected NumericDoubleValues() {
    }

    public NumericDocValues getRawDoubleValues() {
        return new RawNumericDocValues(Double::doubleToRawLongBits);
    }

    public NumericDocValues getRawFloatValues() {
        return new RawNumericDocValues(v -> Float.floatToRawIntBits((float)v));
    }

    public NumericDocValues getRawLongValues() {
        return new RawNumericDocValues(v -> (long)v);
    }

    public static NumericDoubleValues fromField(NumericDocValues values, LongToDoubleFunction decoder) {
        return new FieldNumericDoubleValues(values, decoder);
    }

    private class RawNumericDocValues
    extends NumericDocValues {
        private int docID = -1;
        private final DoubleToLongFunction decorator;

        public RawNumericDocValues(DoubleToLongFunction decorator) {
            this.decorator = decorator;
        }

        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return NumericDoubleValues.this.advanceExact(target);
        }

        public long longValue() throws IOException {
            return this.decorator.applyAsLong(NumericDoubleValues.this.doubleValue());
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FieldNumericDoubleValues
    extends NumericDoubleValues {
        private final NumericDocValues values;
        private final LongToDoubleFunction decoder;

        FieldNumericDoubleValues(NumericDocValues values, LongToDoubleFunction decoder) {
            this.values = values;
            this.decoder = decoder;
        }

        public double doubleValue() throws IOException {
            return this.decoder.applyAsDouble(this.values.longValue());
        }

        public boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }
}

