/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.impl.LuceneIndexScope;
import org.hibernate.search.backend.lucene.search.aggregation.dsl.LuceneSearchAggregationFactory;
import org.hibernate.search.backend.lucene.search.aggregation.dsl.impl.LuceneSearchAggregationFactoryImpl;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.predicate.dsl.impl.LuceneSearchPredicateFactoryImpl;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.impl.LuceneSearchProjectionFactoryImpl;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQuerySelectStep;
import org.hibernate.search.backend.lucene.search.query.dsl.impl.LuceneSearchQuerySelectStepImpl;
import org.hibernate.search.backend.lucene.search.sort.dsl.LuceneSearchSortFactory;
import org.hibernate.search.backend.lucene.search.sort.dsl.impl.LuceneSearchSortFactoryImpl;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactory;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactory;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryExtension;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactoryExtension;
import org.hibernate.search.engine.search.aggregation.dsl.spi.SearchAggregationDslContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.projection.dsl.spi.SearchProjectionDslContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.dsl.SearchQueryDslExtension;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneExtension<H, R, E, LOS>
implements SearchQueryDslExtension<LuceneSearchQuerySelectStep<R, E, LOS>, R, E, LOS>,
SearchQueryExtension<LuceneSearchQuery<H>, H>,
SearchPredicateFactoryExtension<LuceneSearchPredicateFactory>,
SearchSortFactoryExtension<LuceneSearchSortFactory>,
SearchProjectionFactoryExtension<LuceneSearchProjectionFactory<R, E>, R, E>,
SearchAggregationFactoryExtension<LuceneSearchAggregationFactory>,
IndexFieldTypeFactoryExtension<LuceneIndexFieldTypeFactory> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final LuceneExtension<Object, Object, Object, Object> INSTANCE = new LuceneExtension();

    public static <H, R, E, LOS> LuceneExtension<H, R, E, LOS> get() {
        return INSTANCE;
    }

    private LuceneExtension() {
    }

    public Optional<LuceneSearchQuerySelectStep<R, E, LOS>> extendOptional(SearchQuerySelectStep<?, R, E, LOS, ?, ?> original, IndexScope<?> indexScope, BackendSessionContext sessionContext, LoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        if (indexScope instanceof LuceneIndexScope) {
            return Optional.of(new LuceneSearchQuerySelectStepImpl<R, E, LOS>((LuceneIndexScope)indexScope, sessionContext, loadingContextBuilder));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchQuery<H>> extendOptional(SearchQuery<H> original, LoadingContext<?, ?> loadingContext) {
        if (original instanceof LuceneSearchQuery) {
            return Optional.of((LuceneSearchQuery)original);
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchPredicateFactory> extendOptional(SearchPredicateFactory original, SearchPredicateDslContext<?> dslContext) {
        if (dslContext.builderFactory() instanceof LuceneSearchPredicateBuilderFactory) {
            return Optional.of(new LuceneSearchPredicateFactoryImpl(original, dslContext));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchSortFactory> extendOptional(SearchSortFactory original, SearchSortDslContext<?, ?> dslContext) {
        if (dslContext.builderFactory() instanceof LuceneSearchSortBuilderFactory) {
            return Optional.of(new LuceneSearchSortFactoryImpl(original, (SearchSortDslContext<LuceneSearchSortBuilderFactory, LuceneSearchPredicateFactory>)dslContext.withExtendedPredicateFactory((SearchPredicateFactoryExtension)this)));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchProjectionFactory<R, E>> extendOptional(SearchProjectionFactory<R, E> original, SearchProjectionDslContext<?> dslContext) {
        if (dslContext.builderFactory() instanceof LuceneSearchProjectionBuilderFactory) {
            return Optional.of(new LuceneSearchProjectionFactoryImpl<R, E>(original, dslContext));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchAggregationFactory> extendOptional(SearchAggregationFactory original, SearchAggregationDslContext<?, ?> dslContext) {
        if (dslContext.builderFactory() instanceof LuceneSearchAggregationBuilderFactory) {
            return Optional.of(new LuceneSearchAggregationFactoryImpl(original, (SearchAggregationDslContext<LuceneSearchAggregationBuilderFactory, LuceneSearchPredicateFactory>)dslContext.withExtendedPredicateFactory((SearchPredicateFactoryExtension)this)));
        }
        return Optional.empty();
    }

    public LuceneIndexFieldTypeFactory extendOrFail(IndexFieldTypeFactory original) {
        if (original instanceof LuceneIndexFieldTypeFactory) {
            return (LuceneIndexFieldTypeFactory)original;
        }
        throw log.luceneExtensionOnUnknownType(original);
    }
}

