/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.NormalizerDefMapping;

public class SearchMapping {
    private final Set<Map<String, Object>> analyzerDefs = new HashSet<Map<String, Object>>();
    private final Set<Map<String, Object>> normalizerDefs = new HashSet<Map<String, Object>>();
    private final Set<Map<String, Object>> fullTextFilterDefs = new HashSet<Map<String, Object>>();
    private final Map<Class<?>, EntityDescriptor> entities = new HashMap();

    public Set<Map<String, Object>> getAnalyzerDefs() {
        return this.analyzerDefs;
    }

    public Set<Map<String, Object>> getNormalizerDefs() {
        return this.normalizerDefs;
    }

    public Set<Map<String, Object>> getFullTextFilterDefs() {
        return this.fullTextFilterDefs;
    }

    public EntityDescriptor getEntityDescriptor(Class<?> entityType) {
        return this.entities.get(entityType);
    }

    public Set<Class<?>> getMappedEntities() {
        return this.entities.keySet();
    }

    @Deprecated
    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return this.analyzerDef(name, "", tokenizerFactory);
    }

    @Deprecated
    public AnalyzerDefMapping analyzerDef(String name, String tokenizerName, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerName, tokenizerFactory, this);
    }

    @Deprecated
    public NormalizerDefMapping normalizerDef(String name) {
        return new NormalizerDefMapping(name, this);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this);
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this, name, impl);
    }

    static Map<String, Object> addElementToAnnotationArray(Map<String, Object> containingAnnotation, String attributeName) {
        ArrayList<HashMap<String, Object>> array = (ArrayList<HashMap<String, Object>>)containingAnnotation.get(attributeName);
        if (array == null) {
            array = new ArrayList<HashMap<String, Object>>();
            containingAnnotation.put(attributeName, array);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        array.add(param);
        return param;
    }

    void addAnalyzerDef(Map<String, Object> analyzerDef) {
        this.analyzerDefs.add(analyzerDef);
    }

    void addNormalizerDef(Map<String, Object> normalizerDef) {
        this.normalizerDefs.add(normalizerDef);
    }

    EntityDescriptor getEntity(Class<?> entityType) {
        EntityDescriptor entityDescriptor = this.entities.get(entityType);
        if (entityDescriptor == null) {
            entityDescriptor = new EntityDescriptor();
            this.entities.put(entityType, entityDescriptor);
        }
        return entityDescriptor;
    }

    void addFulltextFilterDef(Map<String, Object> fullTextFilterDef) {
        this.fullTextFilterDefs.add(fullTextFilterDef);
    }
}

