/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RangeQueryContext;

public class ConnectedMultiFieldsRangeQueryBuilder
implements RangeTerminationExcludable {
    private final RangeQueryContext rangeContext;
    private final QueryCustomizer queryCustomizer;
    private final List<FieldContext> fieldContexts;
    private final QueryBuildingContext queryContext;

    public ConnectedMultiFieldsRangeQueryBuilder(RangeQueryContext rangeContext, QueryCustomizer queryCustomizer, List<FieldContext> fieldContexts, QueryBuildingContext queryContext) {
        this.rangeContext = rangeContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldContexts = fieldContexts;
        this.queryContext = queryContext;
    }

    @Override
    public RangeTerminationExcludable excludeLimit() {
        if (this.rangeContext.getFrom() != null && this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else if (this.rangeContext.getFrom() != null) {
            this.rangeContext.setExcludeFrom(true);
        } else if (this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else {
            throw new AssertionFailure("Both from and to clause of a range query are null");
        }
        return this;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldContexts.size();
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldContexts.get(0), conversionContext)).createQuery();
        }
        BooleanQuery aggregatedFieldsQuery = new BooleanQuery();
        for (FieldContext fieldContext : this.fieldContexts) {
            aggregatedFieldsQuery.add(this.createQuery(fieldContext, conversionContext), BooleanClause.Occur.SHOULD);
        }
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    private Query createQuery(FieldContext fieldContext, ConversionContext conversionContext) {
        Query perFieldQuery;
        String fieldName = fieldContext.getField();
        Analyzer queryAnalyzer = this.queryContext.getQueryAnalyzer();
        DocumentBuilderIndexedEntity<?> documentBuilder = Helper.getDocumentBuilder(this.queryContext);
        FieldBridge fieldBridge = fieldContext.getFieldBridge() != null ? fieldContext.getFieldBridge() : documentBuilder.getBridge(fieldContext.getField());
        Object fromObject = this.rangeContext.getFrom();
        Object toObject = this.rangeContext.getTo();
        if (fieldBridge != null && NumericFieldBridge.class.isAssignableFrom(fieldBridge.getClass())) {
            perFieldQuery = NumericFieldUtils.createNumericRangeQuery(fieldName, fromObject, toObject, !this.rangeContext.isExcludeFrom(), !this.rangeContext.isExcludeTo());
        } else {
            String fromString = fieldContext.objectToString(documentBuilder, fromObject, conversionContext);
            String lowerTerm = fromString == null ? null : Helper.getAnalyzedTerm(fieldName, fromString, "from", queryAnalyzer, fieldContext);
            String toString = fieldContext.objectToString(documentBuilder, toObject, conversionContext);
            String upperTerm = toString == null ? null : Helper.getAnalyzedTerm(fieldName, toString, "to", queryAnalyzer, fieldContext);
            perFieldQuery = new TermRangeQuery(fieldName, lowerTerm, upperTerm, !this.rangeContext.isExcludeFrom(), !this.rangeContext.isExcludeTo());
        }
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }
}

