/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.TermTermination;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsTermQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;

public class ConnectedTermMatchingContext
implements TermMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;
    private final List<FieldContext> fieldContexts;
    private int firstOfContext = 0;

    public ConnectedTermMatchingContext(TermQueryContext termContext, String field, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.termContext = termContext;
        this.fieldContexts = new ArrayList<FieldContext>(4);
        this.fieldContexts.add(new FieldContext(field));
    }

    public ConnectedTermMatchingContext(TermQueryContext termContext, String[] fields, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.termContext = termContext;
        this.fieldContexts = new ArrayList<FieldContext>(fields.length);
        for (String field : fields) {
            this.fieldContexts.add(new FieldContext(field));
        }
    }

    @Override
    public TermTermination matching(Object value) {
        return new ConnectedMultiFieldsTermQueryBuilder(this.termContext, value, this.fieldContexts, this.queryCustomizer, this.queryContext);
    }

    @Override
    public TermMatchingContext andField(String field) {
        this.fieldContexts.add(new FieldContext(field));
        this.firstOfContext = this.fieldContexts.size() - 1;
        return this;
    }

    @Override
    public TermMatchingContext boostedTo(float boost) {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.getFieldCustomizer().boostedTo(boost);
        }
        return this;
    }

    private List<FieldContext> getCurrentFieldContexts() {
        return this.fieldContexts.subList(this.firstOfContext, this.fieldContexts.size());
    }

    @Override
    public TermMatchingContext ignoreAnalyzer() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreAnalyzer(true);
        }
        return this;
    }

    @Override
    public TermMatchingContext ignoreFieldBridge() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreFieldBridge(true);
        }
        return this;
    }
}

