/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.SingleTaskRunnable;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LuceneBackendQueueTask
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Lock modificationLock;
    private final LuceneBackendResources resources;
    private final List<LuceneWork> queue;
    private final IndexingMonitor monitor;

    LuceneBackendQueueTask(List<LuceneWork> queue, LuceneBackendResources resources, IndexingMonitor monitor) {
        this.queue = queue;
        this.resources = resources;
        this.monitor = monitor;
        this.modificationLock = resources.getParallelModificationLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.modificationLock.lock();
        try {
            this.applyUpdates();
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(e);
            Thread.currentThread().interrupt();
            this.handleException(e);
        }
        catch (Exception e) {
            log.backendError(e);
            this.handleException(e);
        }
        finally {
            this.modificationLock.unlock();
        }
    }

    private void handleException(Exception e) {
        ErrorContextBuilder builder = new ErrorContextBuilder();
        builder.allWorkToBeDone(this.queue);
        builder.errorThatOccurred(e);
        this.resources.getErrorHandler().handle(builder.createErrorContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdates() throws InterruptedException, ExecutionException {
        AbstractWorkspaceImpl workspace = this.resources.getWorkspace();
        ErrorContextBuilder errorContextBuilder = new ErrorContextBuilder();
        errorContextBuilder.allWorkToBeDone(this.queue);
        IndexWriter indexWriter = workspace.getIndexWriter(errorContextBuilder);
        if (indexWriter == null) {
            log.cannotOpenIndexWriterCausePreviousError();
            return;
        }
        LinkedList<LuceneWork> failedUpdates = null;
        try {
            Object task;
            int i;
            ExecutorService executor = this.resources.getWorkersExecutor();
            int queueSize = this.queue.size();
            Future[] submittedTasks = new Future[queueSize];
            for (i = 0; i < queueSize; ++i) {
                task = new SingleTaskRunnable(this.queue.get(i), this.resources, indexWriter, this.monitor);
                submittedTasks[i] = executor.submit((Runnable)task);
            }
            for (i = 0; i < queueSize; ++i) {
                task = submittedTasks[i];
                try {
                    task.get();
                    errorContextBuilder.workCompleted(this.queue.get(i));
                    continue;
                }
                catch (ExecutionException e) {
                    if (failedUpdates == null) {
                        failedUpdates = new LinkedList<LuceneWork>();
                    }
                    failedUpdates.add(this.queue.get(i));
                    errorContextBuilder.errorThatOccurred(e.getCause());
                }
            }
            if (failedUpdates != null) {
                errorContextBuilder.addAllWorkThatFailed(failedUpdates);
                this.resources.getErrorHandler().handle(errorContextBuilder.createErrorContext());
            } else {
                workspace.optimizerPhase();
            }
            workspace.afterTransactionApplied(failedUpdates != null, false);
        }
        catch (Throwable throwable) {
            workspace.afterTransactionApplied(failedUpdates != null, false);
            throw throwable;
        }
    }
}

