/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.index.CorruptIndexException;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.spi.WorkType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="initialized \"blackhole\" backend. Index changes will be prepared but discarded!")
    public void initializedBlackholeBackend();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="closed \"blackhole\" backend.")
    public void closedBlackholeBackend();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="update DirectoryProviders \"blackhole\" backend. Index changes will be prepared but discarded!")
    public void updatedDirectoryProviders();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Exception attempting to instantiate Similarity '%1$s' set for %2$s")
    public void similarityInstantiationException(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Starting JGroups Channel")
    public void jGroupsStartingChannel();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Connected to cluster [ %1$s ]. The node address is %2$s")
    public void jGroupsConnectedToCluster(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="FLUSH is not present in your JGroups stack!  FLUSH is needed to ensure messages are not dropped while new nodes join the cluster.  Will proceed, but inconsistencies may arise!")
    public void jGroupsFlushNotPresentInStack();

    @Message(id=8, value="Error while trying to create a channel using config file: %1$s")
    public SearchException jGroupsChannelCreationUsingFileError(String var1, @Cause Throwable var2);

    @Message(id=9, value="Error while trying to create a channel using config XML: %1$s")
    public SearchException jGroupsChannelCreationUsingXmlError(String var1, @Cause Throwable var2);

    @Message(id=10, value="Error while trying to create a channel using config string: %1$s")
    public SearchException jGroupsChannelCreationFromStringError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Unable to use any JGroups configuration mechanisms provided in properties %1$s. Using default JGroups configuration file!")
    public void jGroupsConfigurationNotFoundInProperties(Properties var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Default JGroups configuration file was not found. Attempt to start JGroups channel with default configuration!")
    public void jGroupsDefaultConfigurationFileNotFound();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Disconnecting and closing JGroups Channel")
    public void jGroupsDisconnectingAndClosingChannel();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="Problem closing channel; setting it to null")
    public void jGroupsClosingChannelError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="Received new cluster view: %1$s")
    public void jGroupsReceivedNewClusterView(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Incorrect message type: %1$s")
    public void incorrectMessageType(Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Work discarded, thread was interrupted while waiting for space to schedule: %1$s")
    public void interruptedWorkError(Runnable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Skipping directory synchronization, previous work still in progress: %1$s")
    public void skippingDirectorySynchronization(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Unable to remove previous marker file from source of %1$s")
    public void unableToRemovePreviousMarket(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Unable to create current marker in source of %1$s")
    public void unableToCreateCurrentMarker(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=21, value="Unable to synchronize source of %1$s")
    public void unableToSynchronizeSource(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Unable to determine current in source directory, will try again during the next synchronization")
    public void unableToDetermineCurrentInSourceDirectory();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23, value="Unable to compare %1$s with %2$s.")
    public void unableToCompareSourceWithDestinationDirectory(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=24, value="Unable to reindex entity on collection change, id cannot be extracted: %1$s")
    public void idCannotBeExtracted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25, value="Service provider has been used but not released: %1$s")
    public void serviceProviderNotReleased(Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26, value="Fail to properly stop service: %1$s")
    public void stopServiceFailed(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Going to reindex %d entities")
    public void indexingEntities(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Reindexed %1$d entities")
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Indexing completed. Reindexed %1$d entities. Unregistering MBean from server")
    public void indexingCompletedAndMBeanUnregistered(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="%1$d documents indexed in %2$d ms")
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="Indexing speed: %1$f documents/second; progress: %2$.2f%%")
    public void indexingSpeed(float var1, float var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=32, value="Could not delete %1$s")
    public void notDeleted(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=33, value="Could not change timestamp for %1$s. Index synchronization may be slow.")
    public void notChangeTimestamp(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=34, value="Hibernate Search %1$s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="Could not close resource.")
    public void couldNotCloseResource(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Cannot guess the Transaction Status: not starting a JTA transaction")
    public void cannotGuessTransactionStatus(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=37, value="Unable to properly close searcher during lucene query: %1$s")
    public void unableToCloseSearcherDuringQuery(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=38, value="Forced to use Document extraction to workaround FieldCache bug in Lucene")
    public void forceToUseDocumentExtraction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="Unable to properly close searcher in ScrollableResults")
    public void unableToCloseSearcherInScrollableResult(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40, value="Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.")
    public void unexpectedValueMissingFromFieldCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=41, value="Index directory not found, creating: '%1$s'")
    public void indexDirectoryNotFoundCreatingNewOne(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=42, value="No current marker in source directory. Has the master being started already?")
    public void noCurrentMarkerInSourceDirectory();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=43, value="Found current marker in source directory - initialization succeeded")
    public void foundCurrentMarker();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=44, value="Abstract classes can never insert index documents. Remove @Indexed.")
    public void abstractClassesCannotInsertDocuments();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=45, value="@ContainedIn is pointing to an entity having @ProvidedId: %1$s. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ")
    public void containedInPointsToProvidedId(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=46, value="FieldCache was enabled on class %1$s but for this type of identifier we can't extract values from the FieldCache: cache disabled")
    public void cannotExtractValueForIdentifier(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=47, value="Unable to close JMS connection for %1$s")
    public void unableToCloseJmsConnection(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=48, value="Unable to retrieve named analyzer: %1$s")
    public void unableToRetrieveNamedAnalyzer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=49, value="Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock")
    public void interruptedWhileWaitingForIndexActivity(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=50, value="It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!")
    public void pushedChangesOutOfTransaction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=51, value="Received null or empty Lucene works list in message.")
    public void receivedEmptyLuceneWorksInMessage();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=52, value="Going to force release of the IndexWriter lock")
    public void forcingReleaseIndexWriterLock();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=53, value="Chunk size must be positive: using default value.")
    public void checkSizeMustBePositive();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=54, value="ReaderProvider contains readers not properly closed at destroy time")
    public void readersNotProperlyClosedInReaderProvider();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=55, value="Unable to close Lucene IndexReader")
    public void unableToCLoseLuceneIndexReader(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=56, value="Unable to un-register existing MBean: %1$s")
    public void unableToUnregisterExistingMBean(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=57, value="Property hibernate.search.autoregister_listeners is set to false. No attempt will be made to register Hibernate Search event listeners.")
    public void eventListenerWontBeRegistered();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=58, value="%1$s")
    public void exceptionOccurred(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=59, value="Worker raises an exception on close()")
    public void workerException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=60, value="ReaderProvider raises an exception on destroy()")
    public void readerProviderExceptionOnDestroy(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=61, value="DirectoryProvider raises an exception on stop() ")
    public void directoryProviderExceptionOnStop(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=62, value="Batch indexing was interrupted")
    public void interruptedBatchIndexing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=63, value="Error during batch indexing: ")
    public void errorDuringBatchIndexing(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=64, value="Error while executing runnable wrapped in a JTA transaction")
    public void errorExecutingRunnableInTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=65, value="Error while rolling back transaction after %1$s")
    public void errorRollingBackTransaction(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=66, value="Failed to initialize SlaveDirectoryProvider %1$s")
    public void failedSlaveDirectoryProviderInitialization(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=67, value="Unable to properly close Lucene directory %1$s")
    public void unableToCloseLuceneDirectory(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=68, value="Unable to retrieve object from message: %1$s")
    public void unableToRetrieveObjectFromMessage(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=69, value="Illegal object retrieved from message")
    public void illegalObjectRetrievedFromMessage(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=70, value="Terminating batch work! Index might end up in inconsistent state.")
    public void terminatingBatchWorkCanCauseInconsistentState();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=71, value="Unable to properly shut down asynchronous indexing work")
    public void unableToShutdownAsynchronousIndexing(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=72, value="Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!")
    public void cannotOpenIndexWriterCausePreviousError();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=73, value="Error in backend")
    public void backendError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=74, value="Unexpected error in Lucene Backend:")
    public void unexpectedErrorInLuceneBackend(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="Configuration setting hibernate.search.lucene_version was not specified, using LUCENE_CURRENT.")
    public void recommendConfiguringLuceneVersion();

    @Message(id=76, value="Could not open Lucene index: index data is corrupted. index name: '%1$s'")
    public SearchException cantOpenCorruptedIndex(@Cause CorruptIndexException var1, String var2);

    @Message(id=77, value="An IOException happened while accessing the Lucene index '%1$s'")
    public SearchException ioExceptionOnIndex(@Cause IOException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=78, value="Timed out waiting to flush all operations to the backend of index %1$s")
    public void unableToShutdownAsynchronousIndexingByTimeout(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=79, value="Serialization protocol version %1$d.%2$d")
    public void serializationProtocol(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=80, value="Received a remote message about an unknown index '%1$s': discarding message!")
    public void messageReceivedForUndefinedIndex(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=81, value="The index '%1$s' is using a non-recommended combination of backend and directoryProvider implementations")
    public void warnSuspiciousBackendDirectoryCombination(String var1);

    @Message(id=82, value="Unable to start serialization layer")
    public SearchException unableToStartSerializationLayer(@Cause Throwable var1);

    @Message(id=83, value="Unable to serialize List<LuceneWork>")
    public SearchException unableToSerializeLuceneWorks(@Cause Throwable var1);

    @Message(id=84, value="Unable to read serialized List<LuceneWork>")
    public SearchException unableToReadSerializedLuceneWorks(@Cause Throwable var1);

    @Message(id=85, value="Attribute type is not recognized and not serializable: %1$s")
    public SearchException attributeNotRecognizedNorSerializable(Class<?> var1);

    @Message(id=86, value="Unknown attribute serialized representation: %1$s")
    public SearchException unknownAttributeSerializedRepresentation(String var1);

    @Message(id=87, value="Unable to read TokenStream")
    public SearchException unableToReadTokenStream();

    @Message(id=88, value="Unable to convert serializable TermVector to Lucene TermVector: %1$s")
    public SearchException unableToConvertSerializableTermVectorToLuceneTermVector(String var1);

    @Message(id=89, value="Unable to convert serializable Index to Lucene Index: %1$s")
    public SearchException unableToConvertSerializableIndexToLuceneIndex(String var1);

    @Message(id=90, value="Unable to convert serializable Store to Lucene Store: %1$s")
    public SearchException unableToConvertSerializableStoreToLuceneStore(String var1);

    @Message(id=91, value="Unknown NumericField type: %1$s")
    public SearchException unknownNumericFieldType(String var1);

    @Message(id=92, value="Conversion from Reader to String not yet implemented")
    public SearchException conversionFromReaderToStringNotYetImplemented();

    @Message(id=93, value="Unknown Field type: %1$s")
    public SearchException unknownFieldType(Class<?> var1);

    @Message(id=94, value="Cannot serialize custom Fieldable '%1$s'. Must be NumericField, Field or a Serializable Fieldable implementation.")
    public SearchException cannotSerializeCustomField(Class<?> var1);

    @Message(id=95, value="Fail to serialize object of type %1$s")
    public SearchException failToSerializeObject(Class<?> var1, @Cause Throwable var2);

    @Message(id=96, value="Fail to deserialize object")
    public SearchException failToDeserializeObject(@Cause Throwable var1);

    @Message(id=97, value="Unable to read file %1$s")
    public SearchException unableToReadFile(String var1, @Cause Throwable var2);

    @Message(id=98, value="Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d")
    public SearchException incompatibleProtocolVersion(int var1, int var2, int var3, int var4);

    @Message(id=99, value="Unable to deserialize Avro stream")
    public SearchException unableToDeserializeAvroStream(@Cause Throwable var1);

    @Message(id=100, value="Cannot deserialize operation %1$s, unknown operation.")
    public SearchException cannotDeserializeOperation(String var1);

    @Message(id=101, value="Cannot deserialize field type %1$s, unknown field type.")
    public SearchException cannotDeserializeField(String var1);

    @Message(id=102, value="Unable to serialize Lucene works in Avro")
    public SearchException unableToSerializeInAvro(@Cause Throwable var1);

    @Message(id=103, value="Unable to initialize IndexManager %1$s")
    public SearchException unableToInitializeIndexManager(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=104, value="Ignoring backend option for index '%1$s', configured IndexManager requires using '%2$s' instead.")
    public void ignoringBackendOptionForIndex(String var1, String var2);

    @Message(id=105, value="Cannot safely compute getResultSize() when a Criteria with restriction is used. Use query.list().size() or query.getResultList().size(). Criteria at stake: %1$s")
    public SearchException cannotGetResultSizeWithCriteriaAndRestriction(String var1);

    @Message(id=106, value="Field %1$s looks like binary but couldn't be decompressed")
    public SearchException fieldLooksBinaryButDecompressionFailed(String var1);

    @Message(id=107, value="Index names %1$s is not defined")
    public SearchException requestedIndexNotDefined(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=108, value="Shutting down backend for IndexManager '%1$s'")
    public void shuttingDownBackend(String var1);

    @Message(id=109, value="%1$s is not an indexed type")
    public IllegalArgumentException notAnIndexedType(String var1);

    @Message(id=110, value="'null' is not a valid indexed type")
    public IllegalArgumentException nullIsInvalidIndexedType();

    @Message(id=111, value="At least one index name must be provided: can't open an IndexReader on nothing")
    public IllegalArgumentException needAtLeastOneIndexName();

    @Message(id=112, value="At least one entity type must be provided: can't open an IndexReader on nothing")
    public IllegalArgumentException needAtLeastOneIndexedEntityType();

    @Message(id=113, value="'null' is not a valid index name")
    public IllegalArgumentException nullIsInvalidIndexName();

    @Message(id=114, value="Could not load resource: '%1$s'")
    public SearchException unableToLoadResource(String var1);

    @Message(id=115, value="Unknown @FullTextFilter: '%1$s'")
    public SearchException unknownFullTextFilter(String var1);

    @Message(id=116, value="Unexpected error during MassIndexer operation")
    public String massIndexerUnexpectedErrorMessage();

    @Message(id=117, value="IOException on the IndexWriter")
    public String ioExceptionOnIndexWriter();

    @Message(id=118, value="Exception during index Merge operation")
    public String exceptionDuringIndexMergeOperation();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=119, value="Skipping optimization on index %1$s as it is already being optimized")
    public void optimizationSkippedStillBusy(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=120, value="There are multiple properties indexed against the same field name '%1$s', but with different indexing settings. The behaviour is undefined.")
    public void inconsistentFieldConfiguration(String var1);

    @Message(id=121, value="Unable to connect to: [%1$s] JGroups channel")
    public SearchException unableConnectingToJGroupsCluster(String var1, @Cause Throwable var2);

    @Message(id=122, value="Unable to start JGroups channel")
    public SearchException unableToStartJGroupsChannel(@Cause Throwable var1);

    @Message(id=123, value="Unable to send Lucene update work via JGroups cluster")
    public SearchException unableToSendWorkViaJGroups(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=124, value="The option 'threadsForIndexWriter' of the MassIndexer is deprecated and is being ignored! Control the size of worker.thread_pool.size for each index instead.")
    public void massIndexerIndexWriterThreadsIgnored();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=125, value="Interceptor enforces skip index operation %2$s on instance of class %1$s")
    public void forceSkipIndexOperationViaInterception(Class<?> var1, WorkType var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=126, value="Interceptor enforces removal of index data instead of index operation %2$s on instance of class %1$s")
    public void forceRemoveOnIndexOperationViaInterception(Class<?> var1, WorkType var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=128, value="Interceptor enforces update of index data instead of index operation %2$s on instance of class %1$s")
    public void forceUpdateOnIndexOperationViaInterception(Class<?> var1, WorkType var2);

    @Message(id=129, value="Object injected for JGroups channel in hibernate.search.services.jgroups.providedChannel is of an unexpected type %1$s (expecting org.jgroups.JChannel)")
    public SearchException jGroupsChannelInjectionError(@Cause Exception var1, Class<?> var2);

    @Message(id=130, value="JGroups channel configuration should be specified in the global section [hibernate.search.services.jgroups.], not as an IndexManager property for index '%1$s'. See http://docs.jboss.org/hibernate/search/4.1/reference/en-US/html_single/#jgroups-backend")
    public SearchException legacyJGroupsConfigurationDefined(String var1);
}

