/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.net.URL;
import java.util.Properties;
import org.hibernate.search.backend.impl.jgroups.JGroupsMasterMessageListener;
import org.hibernate.search.backend.impl.jgroups.MasterSelectorServiceProvider;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategyHolder;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Receiver;

public class JGroupsChannelProvider
implements ServiceProvider<Channel> {
    private static final Log log = LoggerFactory.make();
    public static final String JGROUPS_PREFIX = "hibernate.search.services.jgroups.";
    public static final String CONFIGURATION_FILE = "hibernate.search.services.jgroups.configurationFile";
    public static final String CLUSTER_NAME = "hibernate.search.services.jgroups.clusterName";
    public static final String CHANNEL_INJECT = "hibernate.search.services.jgroups.providedChannel";
    private static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "flush-udp.xml";
    private static final String DEFAULT_CLUSTER_NAME = "Hibernate Search Cluster";
    protected String clusterName;
    private Channel channel;
    private JGroupsMasterMessageListener masterListener;
    private boolean channelIsManaged = true;
    private BuildContext context;

    @Override
    public void start(Properties props, BuildContext context) {
        this.clusterName = props.getProperty(CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        this.prepareJGroupsChannel(props, context);
    }

    @Override
    public Channel getService() {
        return this.channel;
    }

    @Override
    public void stop() {
        this.context.releaseService(MasterSelectorServiceProvider.class);
        this.context = null;
        try {
            if (this.channelIsManaged && this.channel != null && this.channel.isOpen()) {
                log.jGroupsDisconnectingAndClosingChannel();
                this.channel.disconnect();
                this.channel.close();
            }
        }
        catch (Exception toLog) {
            log.jGroupsClosingChannelError(toLog);
            this.channel = null;
        }
    }

    private void prepareJGroupsChannel(Properties props, BuildContext context) {
        this.context = context;
        log.jGroupsStartingChannel();
        this.buildChannel(props);
        NodeSelectorStrategyHolder masterNodeSelector = (NodeSelectorStrategyHolder)context.requestService(MasterSelectorServiceProvider.class);
        this.masterListener = new JGroupsMasterMessageListener(context, masterNodeSelector);
        this.channel.setReceiver((Receiver)this.masterListener);
        if (this.channelIsManaged) {
            try {
                this.channel.connect(this.clusterName);
            }
            catch (Exception e) {
                throw log.unableConnectingToJGroupsCluster(this.clusterName, e);
            }
        }
        masterNodeSelector.setLocalAddress(this.channel.getAddress());
        log.jGroupsConnectedToCluster(this.clusterName, this.channel.getAddress());
        if (!this.channel.flushSupported()) {
            log.jGroupsFlushNotPresentInStack();
        }
    }

    private void buildChannel(Properties props) {
        if (props != null) {
            if (props.containsKey(CHANNEL_INJECT)) {
                Object channelObject = props.get(CHANNEL_INJECT);
                try {
                    this.channel = (JChannel)channelObject;
                    this.channelIsManaged = false;
                }
                catch (ClassCastException e) {
                    throw log.jGroupsChannelInjectionError(e, channelObject.getClass());
                }
            }
            if (props.containsKey(CONFIGURATION_FILE)) {
                String cfg = props.getProperty(CONFIGURATION_FILE);
                try {
                    this.channel = new JChannel(ConfigurationParseHelper.locateConfig(cfg));
                }
                catch (Exception e) {
                    throw log.jGroupsChannelCreationUsingFileError(cfg, e);
                }
            }
        }
        if (this.channel == null) {
            log.jGroupsConfigurationNotFoundInProperties(props);
            try {
                URL fileUrl = ConfigurationParseHelper.locateConfig(DEFAULT_JGROUPS_CONFIGURATION_FILE);
                if (fileUrl != null) {
                    this.channel = new JChannel(fileUrl);
                } else {
                    log.jGroupsDefaultConfigurationFileNotFound();
                    this.channel = new JChannel();
                }
            }
            catch (Exception e) {
                throw log.unableToStartJGroupsChannel(e);
            }
        }
    }
}

