/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.internal.PersistentMap;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.property.access.spi.Setter;

public abstract class AbstractCollectionMapper<T>
implements PropertyMapper {
    protected final CommonCollectionMapperData commonCollectionMapperData;
    protected final Class<? extends T> collectionClass;
    protected final boolean ordinalInId;
    protected final boolean revisionTypeInId;
    private final Constructor<? extends T> proxyConstructor;

    protected AbstractCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, boolean ordinalInId, boolean revisionTypeInId) {
        this.commonCollectionMapperData = commonCollectionMapperData;
        this.collectionClass = collectionClass;
        this.ordinalInId = ordinalInId;
        this.revisionTypeInId = revisionTypeInId;
        try {
            this.proxyConstructor = proxyClass.getConstructor(Initializor.class);
        }
        catch (NoSuchMethodException e) {
            throw new AuditException(e);
        }
    }

    protected abstract Collection getNewCollectionContent(PersistentCollection var1);

    protected abstract Collection getOldCollectionContent(Serializable var1);

    protected abstract void mapToMapFromObject(SessionImplementor var1, Map<String, Object> var2, Map<String, Object> var3, Object var4);

    protected Map<String, Object> createIdMap(int ordinal) {
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        if (this.ordinalInId) {
            idMap.put(this.commonCollectionMapperData.getVerEntCfg().getEmbeddableSetOrdinalPropertyName(), ordinal);
        }
        return idMap;
    }

    private void addCollectionChanges(SessionImplementor session, List<PersistentCollectionChangeData> collectionChanges, Set<Object> changed, RevisionType revisionType, Serializable id) {
        int ordinal = 0;
        for (Object changedObj : changed) {
            HashMap<String, Object> entityData = new HashMap<String, Object>();
            Map<String, Object> originalId = this.createIdMap(ordinal++);
            entityData.put(this.commonCollectionMapperData.getVerEntCfg().getOriginalIdPropName(), originalId);
            collectionChanges.add(new PersistentCollectionChangeData(this.commonCollectionMapperData.getVersionsMiddleEntityName(), entityData, changedObj));
            this.commonCollectionMapperData.getReferencingIdData().getPrefixedMapper().mapToMapFromId(originalId, id);
            this.mapToMapFromObject(session, originalId, entityData, changedObj);
            (this.revisionTypeInId ? originalId : entityData).put(this.commonCollectionMapperData.getVerEntCfg().getRevisionTypePropName(), (Object)revisionType);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        CollectionPersister collectionPersister;
        if (!this.commonCollectionMapperData.getCollectionReferencingPropertyData().getName().equals(referencingPropertyName)) {
            return null;
        }
        CollectionEntry collectionEntry = session.getPersistenceContext().getCollectionEntry(newColl);
        if (collectionEntry != null && !(newColl instanceof PersistentMap) && (collectionPersister = collectionEntry.getCurrentPersister()) != null && !collectionPersister.hasIndex()) {
            return this.mapCollectionChanges(session, newColl, oldColl, id, collectionPersister);
        }
        return this.mapCollectionChanges(session, newColl, oldColl, id);
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        PropertyData propertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
        if (propertyData.isUsingModifiedFlag()) {
            if (this.isNotPersistentCollection(newObj) || this.isNotPersistentCollection(oldObj)) {
                data.put(propertyData.getModifiedFlagPropertyName(), !EqualsHelper.areEqual((Object)newObj, (Object)oldObj));
            } else if (this.isFromNullToEmptyOrFromEmptyToNull((PersistentCollection)newObj, (Serializable)oldObj)) {
                data.put(propertyData.getModifiedFlagPropertyName(), true);
            } else {
                PersistentCollection pc = (PersistentCollection)newObj;
                if (pc != null && !pc.isDirty() || newObj == null && oldObj == null) {
                    data.put(propertyData.getModifiedFlagPropertyName(), false);
                    return;
                }
                List<PersistentCollectionChangeData> changes = this.mapCollectionChanges(session, this.commonCollectionMapperData.getCollectionReferencingPropertyData().getName(), pc, (Serializable)oldObj, null);
                data.put(propertyData.getModifiedFlagPropertyName(), !changes.isEmpty());
            }
        }
    }

    private boolean isNotPersistentCollection(Object obj) {
        return obj != null && !(obj instanceof PersistentCollection);
    }

    private boolean isFromNullToEmptyOrFromEmptyToNull(PersistentCollection newColl, Serializable oldColl) {
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        return oldCollection == null && newCollection != null && newCollection.isEmpty() || newCollection == null && oldCollection != null && oldCollection.isEmpty();
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        PropertyData propertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
        if (propertyData.isUsingModifiedFlag()) {
            data.put(propertyData.getModifiedFlagPropertyName(), propertyData.getName().equals(collectionPropertyName));
        }
    }

    protected abstract Initializor<T> getInitializor(EnversService var1, AuditReaderImplementor var2, Object var3, Number var4, boolean var5);

    @Override
    public void mapToEntityFromMap(final EnversService enversService, final Object obj, final Map data, final Object primaryKey, final AuditReaderImplementor versionsReader, final Number revision) {
        final String revisionTypePropertyName = enversService.getAuditEntitiesConfiguration().getRevisionTypePropName();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Setter setter = ReflectionTools.getSetter(obj.getClass(), AbstractCollectionMapper.this.commonCollectionMapperData.getCollectionReferencingPropertyData(), enversService.getServiceRegistry());
                try {
                    setter.set(obj, AbstractCollectionMapper.this.proxyConstructor.newInstance(AbstractCollectionMapper.this.getInitializor(enversService, versionsReader, primaryKey, revision, RevisionType.DEL.equals(data.get(revisionTypePropertyName)))), null);
                }
                catch (InstantiationException e) {
                    throw new AuditException(e);
                }
                catch (IllegalAccessException e) {
                    throw new AuditException(e);
                }
                catch (InvocationTargetException e) {
                    throw new AuditException(e);
                }
                return null;
            }
        });
    }

    private List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        HashSet<Object> added = new HashSet<Object>();
        if (newColl != null) {
            added.addAll(newCollection);
        }
        if (oldColl != null) {
            added.removeAll(new HashSet(oldCollection));
        }
        this.addCollectionChanges(session, collectionChanges, added, RevisionType.ADD, id);
        HashSet<Object> deleted = new HashSet<Object>();
        if (oldColl != null) {
            deleted.addAll(oldCollection);
        }
        if (newColl != null) {
            deleted.removeAll(new HashSet(newCollection));
        }
        this.addCollectionChanges(session, collectionChanges, deleted, RevisionType.DEL, id);
        return collectionChanges;
    }

    private List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, PersistentCollection newColl, Serializable oldColl, Serializable id, CollectionPersister collectionPersister) {
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        HashSet<Object> added = new HashSet<Object>();
        if (newColl != null) {
            added.addAll(newCollection);
        }
        if (oldColl != null && collectionPersister != null) {
            block0: for (Object object : oldCollection) {
                Iterator addedIt = added.iterator();
                while (addedIt.hasNext()) {
                    Object object2 = addedIt.next();
                    if (!collectionPersister.getElementType().isSame(object, object2)) continue;
                    addedIt.remove();
                    continue block0;
                }
            }
        }
        this.addCollectionChanges(session, collectionChanges, added, RevisionType.ADD, id);
        HashSet<Object> deleted = new HashSet<Object>();
        if (oldColl != null) {
            deleted.addAll(oldCollection);
        }
        if (newColl != null && collectionPersister != null) {
            block2: for (Object object : newCollection) {
                Iterator deletedIt = deleted.iterator();
                while (deletedIt.hasNext()) {
                    Object object2 = deletedIt.next();
                    if (!collectionPersister.getElementType().isSame(object, object2)) continue;
                    deletedIt.remove();
                    continue block2;
                }
            }
        }
        this.addCollectionChanges(session, collectionChanges, deleted, RevisionType.DEL, id);
        return collectionChanges;
    }

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        if (this.commonCollectionMapperData != null) {
            PropertyData propertyData = this.commonCollectionMapperData.getCollectionReferencingPropertyData();
            return propertyData != null && propertyData.isUsingModifiedFlag();
        }
        return false;
    }
}

