/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.Stack;

public class SingletonStack<T>
implements Stack<T> {
    private final T instance;

    public SingletonStack(T instance) {
        this.instance = instance;
    }

    @Override
    public void push(T newCurrent) {
        throw new UnsupportedOperationException("Cannot push to a singleton Stack");
    }

    @Override
    public T pop() {
        throw new UnsupportedOperationException("Cannot pop from a singleton Stack");
    }

    @Override
    public T getCurrent() {
        return this.instance;
    }

    @Override
    public T getPrevious() {
        return null;
    }

    @Override
    public int depth() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public void visitCurrentFirst(Consumer<T> action) {
        action.accept(this.instance);
    }

    @Override
    public <X> X findCurrentFirst(Function<T, X> action) {
        return action.apply(this.instance);
    }
}

