/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.procedure.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.procedure.internal.ProcedureParameterBindingImpl;
import org.hibernate.query.procedure.spi.ProcedureParameterBindingImplementor;
import org.hibernate.query.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;

public class ProcedureParameterBindings
implements QueryParameterBindings {
    private Map<ProcedureParameterImplementor, ProcedureParameterBindingImplementor> parameterBindingMap;

    public <T> void registerParameter(ProcedureParameterImplementor<T> parameter) {
        if (this.parameterBindingMap == null) {
            this.parameterBindingMap = new HashMap<ProcedureParameterImplementor, ProcedureParameterBindingImplementor>();
        }
        this.parameterBindingMap.put(parameter, new ProcedureParameterBindingImpl<T>(parameter));
    }

    @Override
    public boolean isBound(QueryParameter parameter) {
        return false;
    }

    @Override
    public <T> QueryParameterBinding<T> getBinding(QueryParameter<T> parameter) {
        QueryParameterBinding<T> binding = this.locateBinding(parameter);
        if (binding == null) {
            throw new IllegalArgumentException("Could not resolve QueryParameter reference [" + parameter + "] to QueryParameterBinding");
        }
        return binding;
    }

    private <T> QueryParameterBinding<T> locateBinding(QueryParameter<T> parameter) {
        QueryParameterBinding binding;
        if (this.parameterBindingMap.containsKey(parameter)) {
            return this.parameterBindingMap.get(parameter);
        }
        if (StringHelper.isNotEmpty(parameter.getName()) && (binding = this.locateBinding(parameter.getName())) != null) {
            return binding;
        }
        if (parameter.getPosition() != null && (binding = this.locateBinding(parameter.getPosition())) != null) {
            return binding;
        }
        return null;
    }

    private QueryParameterBinding locateBinding(String name) {
        for (Map.Entry<ProcedureParameterImplementor, ProcedureParameterBindingImplementor> entry : this.parameterBindingMap.entrySet()) {
            if (!name.equals(entry.getKey().getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    private QueryParameterBinding locateBinding(int position) {
        for (Map.Entry<ProcedureParameterImplementor, ProcedureParameterBindingImplementor> entry : this.parameterBindingMap.entrySet()) {
            if (entry.getKey().getPosition() == null || position != entry.getKey().getPosition()) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public <T> QueryParameterBinding<T> getBinding(String name) {
        QueryParameterBinding binding = this.locateBinding(name);
        if (binding == null) {
            throw new IllegalArgumentException("Unknown parameter name : " + name);
        }
        return binding;
    }

    @Override
    public <T> QueryParameterBinding<T> getBinding(int position) {
        QueryParameterBinding binding = this.locateBinding(position);
        if (binding == null) {
            throw new IllegalArgumentException("Unknown parameter position : " + position);
        }
        return binding;
    }
}

