/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Collection;
import javax.persistence.TemporalType;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.QueryParameterListBinding;
import org.hibernate.type.Type;

public class QueryParameterListBindingImpl<T>
implements QueryParameterListBinding<T> {
    private Collection<T> bindValues;
    private Type bindType;

    public QueryParameterListBindingImpl(Type type) {
        this.bindType = type;
    }

    @Override
    public void setBindValues(Collection<T> bindValues) {
        if (bindValues == null) {
            throw new IllegalArgumentException("Collection must be not null!");
        }
        this.bindValues = bindValues;
    }

    @Override
    public void setBindValues(Collection<T> values, Type clarifiedType) {
        this.setBindValues(values);
        this.bindType = clarifiedType;
    }

    @Override
    public void setBindValues(Collection<T> values, TemporalType clarifiedTemporalType) {
        this.setBindValues(values);
        Object anElement = values.isEmpty() ? null : values.iterator().next();
        this.bindType = BindingTypeHelper.INSTANCE.determineTypeForTemporalType(clarifiedTemporalType, this.bindType, anElement);
    }

    @Override
    public Collection<T> getBindValues() {
        return this.bindValues;
    }

    @Override
    public Type getBindType() {
        return this.bindType;
    }
}

