/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.persistence.FlushModeType;
import javax.persistence.Tuple;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.Query;
import org.hibernate.SessionException;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.internal.SessionEventListenerManagerImpl;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryConstructorReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.ContextualJdbcConnectionAccess;
import org.hibernate.internal.CoordinatingEntityNameResolver;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.ExceptionConverterImpl;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.JdbcSessionContextImpl;
import org.hibernate.internal.NonContextualJdbcConnectionAccess;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.SharedSessionCreationOptions;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.spi.TupleBuilderTransformer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureCallMemento;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.query.internal.QueryImpl;
import org.hibernate.query.spi.NativeQueryImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public abstract class AbstractSharedSessionContract
implements SharedSessionContractImplementor {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(SessionImpl.class);
    private transient SessionFactoryImpl factory;
    private final String tenantIdentifier;
    private final UUID sessionIdentifier;
    private final boolean isTransactionCoordinatorShared;
    private final Interceptor interceptor;
    private final TimeZone jdbcTimeZone;
    private FlushMode flushMode;
    private boolean autoJoinTransactions;
    private CacheMode cacheMode;
    protected boolean closed;
    protected boolean waitingForAutoClose;
    private transient SessionEventListenerManagerImpl sessionEventsManager = new SessionEventListenerManagerImpl();
    private transient EntityNameResolver entityNameResolver;
    private transient JdbcConnectionAccess jdbcConnectionAccess;
    private transient JdbcSessionContext jdbcSessionContext;
    private transient JdbcCoordinator jdbcCoordinator;
    private transient TransactionImplementor currentHibernateTransaction;
    private transient TransactionCoordinator transactionCoordinator;
    private transient Boolean useStreamForLobBinding;
    private transient long timestamp;
    private transient Integer jdbcBatchSize;
    protected transient ExceptionConverter exceptionConverter;

    public AbstractSharedSessionContract(SessionFactoryImpl factory, SessionCreationOptions options) {
        this.factory = factory;
        this.sessionIdentifier = StandardRandomStrategy.INSTANCE.generateUUID(null);
        this.timestamp = factory.getCache().getRegionFactory().nextTimestamp();
        this.flushMode = options.getInitialSessionFlushMode();
        this.tenantIdentifier = options.getTenantIdentifier();
        if (MultiTenancyStrategy.NONE == factory.getSettings().getMultiTenancyStrategy()) {
            if (this.tenantIdentifier != null) {
                throw new HibernateException("SessionFactory was not configured for multi-tenancy");
            }
        } else if (this.tenantIdentifier == null) {
            throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
        }
        this.interceptor = this.interpret(options.getInterceptor());
        this.jdbcTimeZone = options.getJdbcTimeZone();
        StatementInspector statementInspector = this.interpret(options.getStatementInspector());
        this.jdbcSessionContext = new JdbcSessionContextImpl(this, statementInspector);
        this.entityNameResolver = new CoordinatingEntityNameResolver(factory, this.interceptor);
        if (options instanceof SharedSessionCreationOptions && ((SharedSessionCreationOptions)options).isTransactionCoordinatorShared()) {
            if (options.getConnection() != null) {
                throw new SessionException("Cannot simultaneously share transaction context and specify connection");
            }
            this.isTransactionCoordinatorShared = true;
            SharedSessionCreationOptions sharedOptions = (SharedSessionCreationOptions)options;
            this.transactionCoordinator = sharedOptions.getTransactionCoordinator();
            this.jdbcCoordinator = sharedOptions.getJdbcCoordinator();
            this.currentHibernateTransaction = sharedOptions.getTransaction();
            if (sharedOptions.shouldAutoJoinTransactions()) {
                log.debug("Session creation specified 'autoJoinTransactions', which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
                this.autoJoinTransactions = false;
            }
            if (sharedOptions.getPhysicalConnectionHandlingMode() != this.jdbcCoordinator.getLogicalConnection().getConnectionHandlingMode()) {
                log.debug("Session creation specified 'PhysicalConnectionHandlingMode which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
            }
            this.addSharedSessionTransactionObserver(this.transactionCoordinator);
        } else {
            this.isTransactionCoordinatorShared = false;
            this.autoJoinTransactions = options.shouldAutoJoinTransactions();
            this.jdbcCoordinator = new JdbcCoordinatorImpl(options.getConnection(), this);
            this.transactionCoordinator = factory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class).buildTransactionCoordinator(this.jdbcCoordinator, this);
        }
        this.exceptionConverter = new ExceptionConverterImpl(this);
    }

    protected void addSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return this.autoJoinTransactions;
    }

    private Interceptor interpret(Interceptor interceptor) {
        return interceptor == null ? EmptyInterceptor.INSTANCE : interceptor;
    }

    private StatementInspector interpret(StatementInspector statementInspector) {
        if (statementInspector == null) {
            return this.interceptor::onPrepareStatement;
        }
        return statementInspector;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public Interceptor getInterceptor() {
        this.checkTransactionSynchStatus();
        return this.interceptor;
    }

    @Override
    public JdbcCoordinator getJdbcCoordinator() {
        return this.jdbcCoordinator;
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public JdbcSessionContext getJdbcSessionContext() {
        return this.jdbcSessionContext;
    }

    public EntityNameResolver getEntityNameResolver() {
        return this.entityNameResolver;
    }

    @Override
    public SessionEventListenerManager getEventListenerManager() {
        return this.sessionEventsManager;
    }

    @Override
    public UUID getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    @Override
    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.factory.isClosed();
    }

    @Override
    public void close() {
        if (this.closed && !this.waitingForAutoClose) {
            return;
        }
        if (this.sessionEventsManager != null) {
            this.sessionEventsManager.end();
        }
        if (this.currentHibernateTransaction != null) {
            this.currentHibernateTransaction.invalidate();
        }
        try {
            if (this.shouldCloseJdbcCoordinatorOnClose(this.isTransactionCoordinatorShared)) {
                this.jdbcCoordinator.close();
            }
        }
        finally {
            this.setClosed();
        }
    }

    protected void setClosed() {
        this.closed = true;
        this.waitingForAutoClose = false;
        this.cleanupOnClose();
    }

    protected boolean shouldCloseJdbcCoordinatorOnClose(boolean isTransactionCoordinatorShared) {
        return true;
    }

    protected void cleanupOnClose() {
    }

    @Override
    public void checkOpen(boolean markForRollbackIfClosed) {
        if (this.isClosed()) {
            if (markForRollbackIfClosed) {
                this.markForRollbackOnly();
            }
            throw new IllegalStateException("Session/EntityManager is closed");
        }
    }

    @Deprecated
    protected void errorIfClosed() {
        this.checkOpen();
    }

    @Override
    public void markForRollbackOnly() {
        this.accessTransaction().markRollbackOnly();
    }

    @Override
    public boolean isTransactionInProgress() {
        if (this.waitingForAutoClose) {
            return this.transactionCoordinator.isTransactionActive();
        }
        return !this.isClosed() && this.transactionCoordinator.isTransactionActive();
    }

    @Override
    public Transaction getTransaction() throws HibernateException {
        if (this.getFactory().getSessionFactoryOptions().isJpaBootstrap() && this.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta() && !this.getFactory().getSessionFactoryOptions().isJtaTransactionAccessEnabled()) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        return this.accessTransaction();
    }

    @Override
    public Transaction accessTransaction() {
        if (this.currentHibernateTransaction == null || this.currentHibernateTransaction.getStatus() != TransactionStatus.ACTIVE) {
            this.currentHibernateTransaction = new TransactionImpl(this.getTransactionCoordinator(), this.getExceptionConverter());
        }
        if (!this.isClosed()) {
            this.getTransactionCoordinator().pulse();
        }
        return this.currentHibernateTransaction;
    }

    @Override
    public Transaction beginTransaction() {
        this.checkOpen();
        Transaction result = this.getTransaction();
        result.begin();
        this.timestamp = this.factory.getCache().getRegionFactory().nextTimestamp();
        return result;
    }

    protected void checkTransactionSynchStatus() {
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
    }

    protected void pulseTransactionCoordinator() {
        if (!this.isClosed()) {
            this.transactionCoordinator.pulse();
        }
    }

    protected void delayedAfterCompletion() {
        if (this.transactionCoordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)this.transactionCoordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    protected TransactionImplementor getCurrentTransaction() {
        return this.currentHibernateTransaction;
    }

    @Override
    public boolean isConnected() {
        this.checkTransactionSynchStatus();
        return this.jdbcCoordinator.getLogicalConnection().isOpen();
    }

    @Override
    public JdbcConnectionAccess getJdbcConnectionAccess() {
        if (this.jdbcConnectionAccess == null) {
            this.jdbcConnectionAccess = MultiTenancyStrategy.NONE == this.factory.getSettings().getMultiTenancyStrategy() ? new NonContextualJdbcConnectionAccess(this.getEventListenerManager(), this.factory.getServiceRegistry().getService(ConnectionProvider.class)) : new ContextualJdbcConnectionAccess(this.getTenantIdentifier(), this.getEventListenerManager(), this.factory.getServiceRegistry().getService(MultiTenantConnectionProvider.class));
        }
        return this.jdbcConnectionAccess;
    }

    @Override
    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return new EntityKey(id, persister);
    }

    @Override
    public boolean useStreamForLobBinding() {
        if (this.useStreamForLobBinding == null) {
            this.useStreamForLobBinding = Environment.useStreamsForBinary() || this.getJdbcServices().getJdbcEnvironment().getDialect().useInputStreamToInsertBlob();
        }
        return this.useStreamForLobBinding;
    }

    @Override
    public LobCreator getLobCreator() {
        return Hibernate.getLobCreator(this);
    }

    @Override
    public <T> T execute(LobCreationContext.Callback<T> callback) {
        return (T)this.getJdbcCoordinator().coordinateWork((workExecutor, connection) -> {
            try {
                return callback.executeOnConnection(connection);
            }
            catch (SQLException e) {
                throw this.exceptionConverter.convert(e, "Error creating contextual LOB : " + e.getMessage());
            }
        });
    }

    @Override
    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (!sqlTypeDescriptor.canBeRemapped()) {
            return sqlTypeDescriptor;
        }
        Dialect dialect = this.getJdbcServices().getJdbcEnvironment().getDialect();
        SqlTypeDescriptor remapped = dialect.remapSqlTypeDescriptor(sqlTypeDescriptor);
        return remapped == null ? sqlTypeDescriptor : remapped;
    }

    @Override
    public TimeZone getJdbcTimeZone() {
        return this.jdbcTimeZone;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.getFactory().getJdbcServices();
    }

    @Override
    public void setFlushMode(FlushMode flushMode) {
        this.setHibernateFlushMode(flushMode);
    }

    @Override
    public FlushModeType getFlushMode() {
        return FlushModeTypeHelper.getFlushModeType(this.flushMode);
    }

    @Override
    public void setHibernateFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.flushMode;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    protected HQLQueryPlan getQueryPlan(String query, boolean shallow) throws HibernateException {
        return this.getFactory().getQueryPlanCache().getHQLQueryPlan(query, shallow, this.getLoadQueryInfluencers().getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeQueryPlan(NativeSQLQuerySpecification spec) throws HibernateException {
        return this.getFactory().getQueryPlanCache().getNativeSQLQueryPlan(spec);
    }

    @Override
    public QueryImplementor getNamedQuery(String name) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        NamedQueryDefinition queryDefinition = this.factory.getNamedQueryRepository().getNamedQueryDefinition(name);
        if (queryDefinition != null) {
            return this.createQuery(queryDefinition);
        }
        NamedSQLQueryDefinition nativeQueryDefinition = this.factory.getNamedQueryRepository().getNamedSQLQueryDefinition(name);
        if (nativeQueryDefinition != null) {
            return this.createNativeQuery(nativeQueryDefinition, true);
        }
        throw this.exceptionConverter.convert(new IllegalArgumentException("No query defined for that name [" + name + "]"));
    }

    protected QueryImplementor createQuery(NamedQueryDefinition queryDefinition) {
        String queryString = queryDefinition.getQueryString();
        QueryImpl query = new QueryImpl(this, this.getQueryPlan(queryString, false).getParameterMetadata(), queryString);
        query.setHibernateFlushMode(queryDefinition.getFlushMode());
        query.setComment(queryDefinition.getComment() != null ? queryDefinition.getComment() : queryDefinition.getName());
        if (queryDefinition.getLockOptions() != null) {
            query.setLockOptions(queryDefinition.getLockOptions());
        }
        this.initQueryFromNamedDefinition(query, queryDefinition);
        return query;
    }

    private NativeQueryImplementor createNativeQuery(NamedSQLQueryDefinition queryDefinition, boolean isOrdinalParameterZeroBased) {
        ParameterMetadata parameterMetadata = this.factory.getQueryPlanCache().getSQLParameterMetadata(queryDefinition.getQueryString(), isOrdinalParameterZeroBased);
        return this.getNativeQueryImplementor(queryDefinition, parameterMetadata);
    }

    private NativeQueryImplementor getNativeQueryImplementor(NamedSQLQueryDefinition queryDefinition, ParameterMetadata parameterMetadata) {
        NativeQueryImpl query = new NativeQueryImpl(queryDefinition, this, parameterMetadata);
        query.setComment(queryDefinition.getComment() != null ? queryDefinition.getComment() : queryDefinition.getName());
        this.initQueryFromNamedDefinition(query, queryDefinition);
        this.applyQuerySettingsAndHints(query);
        return query;
    }

    protected void initQueryFromNamedDefinition(org.hibernate.query.Query query, NamedQueryDefinition nqd) {
        query.setCacheable(nqd.isCacheable());
        query.setCacheRegion(nqd.getCacheRegion());
        query.setReadOnly(nqd.isReadOnly());
        if (nqd.getTimeout() != null) {
            query.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query.setFetchSize(nqd.getFetchSize());
        }
        if (nqd.getCacheMode() != null) {
            query.setCacheMode(nqd.getCacheMode());
        }
        if (nqd.getComment() != null) {
            query.setComment(nqd.getComment());
        }
        if (nqd.getFirstResult() != null) {
            query.setFirstResult(nqd.getFirstResult());
        }
        if (nqd.getMaxResults() != null) {
            query.setMaxResults(nqd.getMaxResults());
        }
        if (nqd.getFlushMode() != null) {
            query.setHibernateFlushMode(nqd.getFlushMode());
        }
    }

    @Override
    public QueryImplementor createQuery(String queryString) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        try {
            QueryImpl query = new QueryImpl(this, this.getQueryPlan(queryString, false).getParameterMetadata(), queryString);
            query.setComment(queryString);
            this.applyQuerySettingsAndHints(query);
            return query;
        }
        catch (RuntimeException e) {
            throw this.exceptionConverter.convert(e);
        }
    }

    protected void applyQuerySettingsAndHints(org.hibernate.query.Query query) {
    }

    public <T> QueryImplementor<T> createQuery(String queryString, Class<T> resultClass) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        try {
            QueryImplementor query = this.createQuery(queryString);
            this.resultClassChecking(resultClass, query);
            return query;
        }
        catch (RuntimeException e) {
            throw this.exceptionConverter.convert(e);
        }
    }

    protected void resultClassChecking(Class resultClass, Query hqlQuery) {
        HQLQueryPlan queryPlan = this.getFactory().getQueryPlanCache().getHQLQueryPlan(hqlQuery.getQueryString(), false, this.getLoadQueryInfluencers().getEnabledFilters());
        if (queryPlan.getTranslators()[0].isManipulationStatement()) {
            throw new IllegalArgumentException("Update/delete queries cannot be typed");
        }
        if (!Object[].class.equals((Object)resultClass)) {
            if (Tuple.class.equals((Object)resultClass)) {
                TupleBuilderTransformer tupleTransformer = new TupleBuilderTransformer(hqlQuery);
                hqlQuery.setResultTransformer(tupleTransformer);
            } else {
                Class dynamicInstantiationClass = queryPlan.getDynamicInstantiationResultType();
                if (dynamicInstantiationClass != null) {
                    if (!resultClass.isAssignableFrom(dynamicInstantiationClass)) {
                        throw new IllegalArgumentException("Mismatch in requested result type [" + resultClass.getName() + "] and actual result type [" + dynamicInstantiationClass.getName() + "]");
                    }
                } else if (queryPlan.getTranslators()[0].getReturnTypes().length == 1) {
                    Type queryResultType = queryPlan.getTranslators()[0].getReturnTypes()[0];
                    if (!resultClass.isAssignableFrom(queryResultType.getReturnedClass())) {
                        throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + queryResultType.getReturnedClass() + "]");
                    }
                } else {
                    throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return using requested result type [" + resultClass.getName() + "]");
                }
            }
        }
    }

    @Override
    public QueryImplementor createNamedQuery(String name) {
        QueryImplementor query = this.buildQueryFromName(name, null);
        query.getParameterMetadata().setOrdinalParametersZeroBased(false);
        return query;
    }

    protected <T> QueryImplementor<T> buildQueryFromName(String name, Class<T> resultType) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        NamedQueryDefinition namedQueryDefinition = this.getFactory().getNamedQueryRepository().getNamedQueryDefinition(name);
        if (namedQueryDefinition != null) {
            return this.createQuery(namedQueryDefinition, resultType);
        }
        NamedSQLQueryDefinition nativeQueryDefinition = this.getFactory().getNamedQueryRepository().getNamedSQLQueryDefinition(name);
        if (nativeQueryDefinition != null) {
            return this.createNativeQuery(nativeQueryDefinition, resultType);
        }
        throw this.exceptionConverter.convert(new IllegalArgumentException("No query defined for that name [" + name + "]"));
    }

    protected <T> QueryImplementor<T> createQuery(NamedQueryDefinition namedQueryDefinition, Class<T> resultType) {
        QueryImplementor query = this.createQuery(namedQueryDefinition);
        if (resultType != null) {
            this.resultClassChecking(resultType, query);
        }
        return query;
    }

    protected <T> NativeQueryImplementor createNativeQuery(NamedSQLQueryDefinition queryDefinition, Class<T> resultType) {
        if (resultType != null) {
            this.resultClassChecking(resultType, queryDefinition);
        }
        NativeQueryImpl query = new NativeQueryImpl(queryDefinition, this, this.factory.getQueryPlanCache().getSQLParameterMetadata(queryDefinition.getQueryString(), false));
        query.setHibernateFlushMode(queryDefinition.getFlushMode());
        query.setComment(queryDefinition.getComment() != null ? queryDefinition.getComment() : queryDefinition.getName());
        if (queryDefinition.getLockOptions() != null) {
            query.setLockOptions(queryDefinition.getLockOptions());
        }
        this.initQueryFromNamedDefinition(query, queryDefinition);
        this.applyQuerySettingsAndHints(query);
        return query;
    }

    protected void resultClassChecking(Class resultType, NamedSQLQueryDefinition namedQueryDefinition) {
        NativeSQLQueryReturn[] queryReturns;
        if (namedQueryDefinition.getQueryReturns() != null) {
            queryReturns = namedQueryDefinition.getQueryReturns();
        } else if (namedQueryDefinition.getResultSetRef() != null) {
            ResultSetMappingDefinition rsMapping = this.getFactory().getNamedQueryRepository().getResultSetMappingDefinition(namedQueryDefinition.getResultSetRef());
            queryReturns = rsMapping.getQueryReturns();
        } else {
            throw new AssertionFailure("Unsupported named query model. Please report the bug in Hibernate EntityManager");
        }
        if (queryReturns.length > 1) {
            throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
        }
        NativeSQLQueryReturn nativeSQLQueryReturn = queryReturns[0];
        if (nativeSQLQueryReturn instanceof NativeSQLQueryRootReturn) {
            Class actualReturnedClass;
            String entityClassName = ((NativeSQLQueryRootReturn)nativeSQLQueryReturn).getReturnEntityName();
            try {
                actualReturnedClass = this.getFactory().getServiceRegistry().getService(ClassLoaderService.class).classForName(entityClassName);
            }
            catch (ClassLoadingException e) {
                throw new AssertionFailure("Unable to load class [" + entityClassName + "] declared on named native query [" + namedQueryDefinition.getName() + "]");
            }
            if (!resultType.isAssignableFrom(actualReturnedClass)) {
                throw this.buildIncompatibleException(resultType, actualReturnedClass);
            }
        } else if (nativeSQLQueryReturn instanceof NativeSQLQueryConstructorReturn) {
            NativeSQLQueryConstructorReturn ctorRtn = (NativeSQLQueryConstructorReturn)nativeSQLQueryReturn;
            if (!resultType.isAssignableFrom(ctorRtn.getTargetClass())) {
                throw this.buildIncompatibleException(resultType, ctorRtn.getTargetClass());
            }
        } else {
            log.debugf("Skiping unhandled NativeSQLQueryReturn type : " + nativeSQLQueryReturn, new Object[0]);
        }
    }

    private IllegalArgumentException buildIncompatibleException(Class<?> resultClass, Class<?> actualResultClass) {
        return new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + actualResultClass + "]");
    }

    @Override
    public <R> QueryImplementor<R> createNamedQuery(String name, Class<R> resultClass) {
        return this.buildQueryFromName(name, resultClass);
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString) {
        NativeQueryImpl query = (NativeQueryImpl)this.getNativeQueryImplementor(sqlString, false);
        query.setZeroBasedParametersIndex(false);
        return query;
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString, Class resultClass) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        try {
            NativeQueryImplementor query = this.createNativeQuery(sqlString);
            query.addEntity("alias1", resultClass.getName(), LockMode.READ);
            return query;
        }
        catch (RuntimeException he) {
            throw this.exceptionConverter.convert(he);
        }
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        try {
            NativeQueryImplementor query = this.createNativeQuery(sqlString);
            query.setResultSetMapping(resultSetMapping);
            return query;
        }
        catch (RuntimeException he) {
            throw this.exceptionConverter.convert(he);
        }
    }

    @Override
    public NativeQueryImplementor getNamedNativeQuery(String name) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        NamedSQLQueryDefinition nativeQueryDefinition = this.factory.getNamedQueryRepository().getNamedSQLQueryDefinition(name);
        if (nativeQueryDefinition != null) {
            return this.createNativeQuery(nativeQueryDefinition, true);
        }
        throw this.exceptionConverter.convert(new IllegalArgumentException("No query defined for that name [" + name + "]"));
    }

    @Override
    public NativeQueryImplementor createSQLQuery(String queryString) {
        return this.getNativeQueryImplementor(queryString, true);
    }

    protected NativeQueryImplementor getNativeQueryImplementor(String queryString, boolean isOrdinalParameterZeroBased) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.delayedAfterCompletion();
        try {
            NativeQueryImpl query = new NativeQueryImpl(queryString, false, this, this.getFactory().getQueryPlanCache().getSQLParameterMetadata(queryString, isOrdinalParameterZeroBased));
            query.setComment("dynamic native SQL query");
            return query;
        }
        catch (RuntimeException he) {
            throw this.exceptionConverter.convert(he);
        }
    }

    @Override
    public NativeQueryImplementor getNamedSQLQuery(String name) {
        NativeQueryImpl nativeQuery = (NativeQueryImpl)this.getNamedNativeQuery(name);
        nativeQuery.setZeroBasedParametersIndex(true);
        return nativeQuery;
    }

    @Override
    public ProcedureCall getNamedProcedureCall(String name) {
        this.checkOpen();
        ProcedureCallMemento memento = this.factory.getNamedQueryRepository().getNamedProcedureCallMemento(name);
        if (memento == null) {
            throw new IllegalArgumentException("Could not find named stored procedure call with that registration name : " + name);
        }
        ProcedureCall procedureCall = memento.makeProcedureCall(this);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultClasses);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultSetMappings);
        return procedureCall;
    }

    protected abstract Object load(String var1, Serializable var2);

    @Override
    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) {
        return this.listCustomQuery(this.getNativeQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public ScrollableResultsImplementor scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) {
        return this.scrollCustomQuery(this.getNativeQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public ExceptionConverter getExceptionConverter() {
        return this.exceptionConverter;
    }

    @Override
    public Integer getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    @Override
    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        log.trace("Serializing " + this.getClass().getSimpleName() + " [");
        if (!this.jdbcCoordinator.isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize " + this.getClass().getSimpleName() + " [" + this.getSessionIdentifier() + "] while connected");
        }
        if (this.isTransactionCoordinatorShared) {
            throw new IllegalStateException("Cannot serialize " + this.getClass().getSimpleName() + " [" + this.getSessionIdentifier() + "] as it has a shared TransactionCoordinator");
        }
        oos.defaultWriteObject();
        this.factory.serialize(oos);
        oos.writeObject(this.jdbcSessionContext.getStatementInspector());
        this.jdbcCoordinator.serialize(oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, SQLException {
        log.trace("Deserializing " + this.getClass().getSimpleName());
        ois.defaultReadObject();
        this.sessionEventsManager = new SessionEventListenerManagerImpl();
        this.factory = SessionFactoryImpl.deserialize(ois);
        this.jdbcSessionContext = new JdbcSessionContextImpl(this, (StatementInspector)ois.readObject());
        this.jdbcCoordinator = JdbcCoordinatorImpl.deserialize(ois, this);
        this.transactionCoordinator = this.factory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class).buildTransactionCoordinator(this.jdbcCoordinator, this);
        this.entityNameResolver = new CoordinatingEntityNameResolver(this.factory, this.interceptor);
    }
}

