/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.BigDecimalTypeDescriptor;
import org.hibernate.type.descriptor.java.BigIntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.BlobTypeDescriptor;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.ByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.ByteTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarTypeDescriptor;
import org.hibernate.type.descriptor.java.CharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.CharacterTypeDescriptor;
import org.hibernate.type.descriptor.java.ClassTypeDescriptor;
import org.hibernate.type.descriptor.java.ClobTypeDescriptor;
import org.hibernate.type.descriptor.java.CurrencyTypeDescriptor;
import org.hibernate.type.descriptor.java.DateTypeDescriptor;
import org.hibernate.type.descriptor.java.DoubleTypeDescriptor;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.FloatTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcDateTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimeTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.hibernate.type.descriptor.java.LocaleTypeDescriptor;
import org.hibernate.type.descriptor.java.LongTypeDescriptor;
import org.hibernate.type.descriptor.java.NClobTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveCharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.SerializableTypeDescriptor;
import org.hibernate.type.descriptor.java.ShortTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.java.TimeZoneTypeDescriptor;
import org.hibernate.type.descriptor.java.UUIDTypeDescriptor;
import org.hibernate.type.descriptor.java.UrlTypeDescriptor;
import org.jboss.logging.Logger;

public class JavaTypeDescriptorRegistry {
    private static final Logger log = Logger.getLogger(JavaTypeDescriptorRegistry.class);
    public static final JavaTypeDescriptorRegistry INSTANCE = new JavaTypeDescriptorRegistry();
    private ConcurrentHashMap<Class, JavaTypeDescriptor> descriptorsByClass = new ConcurrentHashMap();

    public JavaTypeDescriptorRegistry() {
        this.addDescriptorInternal(ByteTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BooleanTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(CharacterTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ShortTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(IntegerTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(LongTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(FloatTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(DoubleTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BigDecimalTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BigIntegerTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(StringTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(BlobTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ClobTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(NClobTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ByteArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(CharacterArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(PrimitiveByteArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(PrimitiveCharacterArrayTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(CalendarTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(DateTypeDescriptor.INSTANCE);
        this.descriptorsByClass.put(Date.class, JdbcDateTypeDescriptor.INSTANCE);
        this.descriptorsByClass.put(Time.class, JdbcTimeTypeDescriptor.INSTANCE);
        this.descriptorsByClass.put(Timestamp.class, JdbcTimestampTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(TimeZoneTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(ClassTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(CurrencyTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(LocaleTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(UrlTypeDescriptor.INSTANCE);
        this.addDescriptorInternal(UUIDTypeDescriptor.INSTANCE);
    }

    private JavaTypeDescriptor addDescriptorInternal(JavaTypeDescriptor descriptor) {
        return this.descriptorsByClass.put(descriptor.getJavaTypeClass(), descriptor);
    }

    public void addDescriptor(JavaTypeDescriptor descriptor) {
        JavaTypeDescriptor old = this.addDescriptorInternal(descriptor);
        if (old != null) {
            log.debugf("JavaTypeDescriptorRegistry entry replaced : %s -> %s (was %s)", descriptor.getJavaTypeClass(), (Object)descriptor, (Object)old);
        }
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class passed to locate Java type descriptor cannot be null");
        }
        EnumJavaTypeDescriptor<T> descriptor = this.descriptorsByClass.get(cls);
        if (descriptor != null) {
            return descriptor;
        }
        if (cls.isEnum()) {
            descriptor = new EnumJavaTypeDescriptor<T>(cls);
            this.descriptorsByClass.put(cls, descriptor);
            return descriptor;
        }
        if (Serializable.class.isAssignableFrom(cls)) {
            return new SerializableTypeDescriptor<T>(cls);
        }
        for (Map.Entry<Class, JavaTypeDescriptor> entry : this.descriptorsByClass.entrySet()) {
            if (!entry.getKey().isAssignableFrom(cls)) continue;
            log.debugf("Using  cached JavaTypeDescriptor instance for Java class [%s]", (Object)cls.getName());
            return entry.getValue();
        }
        log.warnf("Could not find matching type descriptor for requested Java class [%s]; using fallback", (Object)cls.getName());
        return new FallbackJavaTypeDescriptor<T>(cls);
    }

    public static class FallbackJavaTypeDescriptor<T>
    extends AbstractTypeDescriptor<T> {
        protected FallbackJavaTypeDescriptor(Class<T> type) {
            super(type, ImmutableMutabilityPlan.INSTANCE);
        }

        @Override
        public String toString(T value) {
            return value == null ? "<null>" : value.toString();
        }

        @Override
        public T fromString(String string) {
            throw new HibernateException("Not known how to convert String to given type [" + this.getJavaTypeClass().getName() + "]");
        }

        @Override
        public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
            return (X)value;
        }

        @Override
        public <X> T wrap(X value, WrapperOptions options) {
            return (T)value;
        }
    }
}

