/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.HibernateException;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class SchemaExportTask
extends MatchingTask {
    private List<FileSet> fileSets = new LinkedList<FileSet>();
    private File propertiesFile;
    private File configurationFile;
    private File outputFile;
    private boolean quiet;
    private boolean text;
    private boolean drop;
    private boolean create;
    private boolean haltOnError;
    private String delimiter;
    private String implicitNamingStrategy;
    private String physicalNamingStrategy;

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public void setProperties(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new BuildException("Properties file: " + propertiesFile + " does not exist.");
        }
        this.log("Using properties file " + propertiesFile, 4);
        this.propertiesFile = propertiesFile;
    }

    public void setConfig(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(File outputFile) {
        this.outputFile = outputFile;
    }

    @Deprecated
    public void setNamingStrategy(String namingStrategy) {
        DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedNamingStrategyAntArgument();
    }

    public void setImplicitNamingStrategy(String implicitNamingStrategy) {
        this.implicitNamingStrategy = implicitNamingStrategy;
    }

    public void setPhysicalNamingStrategy(String physicalNamingStrategy) {
        this.physicalNamingStrategy = physicalNamingStrategy;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void execute() throws BuildException {
        try {
            this.buildSchemaExport().execute(!this.quiet, !this.text, this.drop, this.create);
        }
        catch (HibernateException e) {
            throw new BuildException("Schema text failed: " + e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("File not found: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("IOException : " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String[] getFiles() {
        LinkedList<String> files = new LinkedList<String>();
        for (FileSet fileSet : this.fileSets) {
            String[] dsFiles;
            DirectoryScanner ds = fileSet.getDirectoryScanner(this.getProject());
            for (String dsFileName : dsFiles = ds.getIncludedFiles()) {
                File f = new File(dsFileName);
                if (!f.isFile()) {
                    f = new File(ds.getBasedir(), dsFileName);
                }
                files.add(f.getAbsolutePath());
            }
        }
        return ArrayHelper.toStringArray(files);
    }

    private SchemaExport buildSchemaExport() throws Exception {
        BootstrapServiceRegistry bsr = new BootstrapServiceRegistryBuilder().build();
        MetadataSources metadataSources = new MetadataSources(bsr);
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
        if (this.configurationFile != null) {
            ssrBuilder.configure(this.configurationFile);
        }
        if (this.propertiesFile != null) {
            ssrBuilder.loadProperties(this.propertiesFile);
        }
        ssrBuilder.applySettings(this.getProject().getProperties());
        for (String fileName : this.getFiles()) {
            if (fileName.endsWith(".jar")) {
                metadataSources.addJar(new File(fileName));
                continue;
            }
            metadataSources.addFile(fileName);
        }
        StandardServiceRegistryImpl ssr = (StandardServiceRegistryImpl)ssrBuilder.build();
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder(ssr);
        ClassLoaderService classLoaderService = bsr.getService(ClassLoaderService.class);
        if (this.implicitNamingStrategy != null) {
            metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)classLoaderService.classForName(this.implicitNamingStrategy).newInstance());
        }
        if (this.physicalNamingStrategy != null) {
            metadataBuilder.applyPhysicalNamingStrategy((PhysicalNamingStrategy)classLoaderService.classForName(this.physicalNamingStrategy).newInstance());
        }
        return new SchemaExport((MetadataImplementor)metadataBuilder.build()).setHaltOnError(this.haltOnError).setOutputFile(this.outputFile.getPath()).setDelimiter(this.delimiter);
    }
}

