/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.List;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.internal.StandardTableExporter;

public class TemporaryTableExporter
extends StandardTableExporter {
    public TemporaryTableExporter(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String[] getSqlCreateStrings(Table exportable, Metadata metadata) {
        if (this.dialect.supportsTemporaryTables()) {
            String temporaryTableName = TemporaryTableExporter.generateTableName(this.dialect, exportable);
            Table temporaryTable = new Table(Identifier.toIdentifier(exportable.getQuotedCatalog()), Identifier.toIdentifier(exportable.getQuotedSchema()), Identifier.toIdentifier(temporaryTableName), false);
            for (Column column : exportable.getPrimaryKey().getColumns()) {
                Column clone = column.clone();
                temporaryTable.addColumn(clone);
            }
            return super.getSqlCreateStrings(temporaryTable, metadata);
        }
        return null;
    }

    public static String generateTableName(Dialect dialect, Table primaryTable) {
        return dialect.generateTemporaryTableName(primaryTable.getName());
    }

    @Override
    protected String tableCreateString(boolean hasPrimaryKey) {
        return this.dialect.getCreateTemporaryTableString();
    }

    @Override
    protected void applyTableCheck(Table table, StringBuilder buf) {
    }

    @Override
    protected void applyComments(Table table, List<String> sqlStrings) {
    }

    @Override
    protected void applyTableTypeString(StringBuilder buf) {
        buf.append(" ").append(this.dialect.getCreateTemporaryTablePostfix());
    }

    @Override
    public String[] getSqlDropStrings(Table exportable, Metadata metadata) {
        return null;
    }
}

