/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.Target;

public class TargetDatabaseImpl
implements Target {
    private final JdbcConnectionAccess connectionAccess;
    private Connection connection;
    private Statement statement;

    public TargetDatabaseImpl(JdbcConnectionAccess connectionAccess) {
        this.connectionAccess = connectionAccess;
    }

    @Override
    public boolean acceptsImportScriptActions() {
        return true;
    }

    @Override
    public void prepare() {
        try {
            this.connection = this.connectionAccess.obtainConnection();
        }
        catch (SQLException e) {
            throw new SchemaManagementException("Unable to open JDBC connection for schema management target", e);
        }
        try {
            this.statement = this.connection.createStatement();
        }
        catch (SQLException e) {
            throw new SchemaManagementException("Unable to create JDBC Statement for schema management target", e);
        }
    }

    @Override
    public void accept(String action) {
        try {
            this.statement.executeUpdate(action);
        }
        catch (SQLException e) {
            throw new SchemaManagementException("Unable to execute schema management to JDBC target [" + action + "]", e);
        }
    }

    @Override
    public void release() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connectionAccess.releaseConnection(this.connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

