/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.Iterator;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaValidator;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;

public class SchemaValidatorImpl
implements SchemaValidator {
    private final Dialect dialect;

    public SchemaValidatorImpl(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public void doValidation(Metadata metadata, DatabaseInformation databaseInformation) {
        for (Schema schema : metadata.getDatabase().getSchemas()) {
            for (Table table : schema.getTables()) {
                if (!table.isPhysicalTable()) continue;
                TableInformation tableInformation = databaseInformation.getTableInformation(table.getQualifiedTableName());
                this.validateTable(table, tableInformation, metadata);
            }
        }
        for (Schema schema : metadata.getDatabase().getSchemas()) {
            for (Sequence sequence : schema.getSequences()) {
                SequenceInformation sequenceInformation = databaseInformation.getSequenceInformation(sequence.getName());
                this.validateSequence(sequence, sequenceInformation);
            }
        }
    }

    protected void validateTable(Table table, TableInformation tableInformation, Metadata metadata) {
        if (tableInformation == null) {
            throw new SchemaManagementException(String.format("Schema-validation: missing table [%s]", table.getName()));
        }
        Iterator selectableItr = table.getColumnIterator();
        while (selectableItr.hasNext()) {
            Selectable selectable = (Selectable)selectableItr.next();
            if (!Column.class.isInstance(selectable)) continue;
            Column column = (Column)selectable;
            ColumnInformation existingColumn = tableInformation.getColumn(Identifier.toIdentifier(column.getQuotedName()));
            if (existingColumn == null) {
                throw new SchemaManagementException(String.format("Schema-validation: missing column [%s] in table [%s]", column.getName(), table.getName()));
            }
            this.validateColumnType(table, column, existingColumn, metadata);
        }
    }

    protected void validateColumnType(Table table, Column column, ColumnInformation columnInformation, Metadata metadata) {
        boolean typesMatch;
        boolean bl = typesMatch = column.getSqlTypeCode(metadata) == columnInformation.getTypeCode() || column.getSqlType(this.dialect, metadata).toLowerCase().startsWith(columnInformation.getTypeName().toLowerCase());
        if (!typesMatch) {
            throw new SchemaManagementException(String.format("Schema-validation: wrong column type encountered in column [%s] in table [%s]; found [%s (Types#%s)], but expecting [%s (Types#%s)]", column.getName(), table.getName(), columnInformation.getTypeName().toLowerCase(), JdbcTypeNameMapper.getTypeName(columnInformation.getTypeCode()), column.getSqlType().toLowerCase(), JdbcTypeNameMapper.getTypeName(column.getSqlTypeCode(metadata))));
        }
    }

    protected void validateSequence(Sequence sequence, SequenceInformation sequenceInformation) {
        if (sequenceInformation == null) {
            throw new SchemaManagementException(String.format("Schema-validation: missing sequence [%s]", sequence.getName()));
        }
        if (sequenceInformation.getIncrementSize() > 0 && sequence.getIncrementSize() != sequenceInformation.getIncrementSize()) {
            throw new SchemaManagementException(String.format("Schema-validation: sequence [%s] defined inconsistent increment-size; found [%s] but expecting [%s]", sequence.getName(), sequenceInformation.getIncrementSize(), sequence.getIncrementSize()));
        }
    }
}

