/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal.legacy;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.internal.ExtractionContextImpl;
import org.hibernate.tool.schema.extract.internal.InformationExtractorJdbcDatabaseMetaDataImpl;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.extract.spi.PrimaryKeyInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;

@Deprecated
public class DatabaseInformationImpl
implements DatabaseInformation,
ExtractionContext.RegisteredObjectAccess {
    private final InformationExtractor extractor;
    private final ExtractionContext extractionContext;
    private final JdbcEnvironment jdbcEnvironment;
    private final Identifier defaultCatalogName;
    private final Identifier defaultSchemaName;
    private final Map<QualifiedTableName, TableInformation> tableInformationMap = new HashMap<QualifiedTableName, TableInformation>();
    private final Map<QualifiedSequenceName, SequenceInformation> sequenceInformationMap = new HashMap<QualifiedSequenceName, SequenceInformation>();

    public DatabaseInformationImpl(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, JdbcConnectionAccess jdbcConnectionAccess, Identifier defaultCatalogName, Identifier defaultSchemaName) throws SQLException {
        this.jdbcEnvironment = jdbcEnvironment;
        this.defaultCatalogName = defaultCatalogName;
        this.defaultSchemaName = defaultSchemaName;
        this.extractionContext = new ExtractionContextImpl(serviceRegistry, jdbcEnvironment, jdbcConnectionAccess, this, defaultCatalogName, defaultSchemaName);
        this.extractor = new InformationExtractorJdbcDatabaseMetaDataImpl(this.extractionContext);
        this.initializeSequences();
    }

    private void initializeSequences() throws SQLException {
        Iterable<SequenceInformation> itr = this.jdbcEnvironment.getDialect().getSequenceInformationExtractor().extractMetadata(this.extractionContext);
        for (SequenceInformation sequenceInformation : itr) {
            this.sequenceInformationMap.put(new QualifiedSequenceName(null, null, sequenceInformation.getSequenceName().getSequenceName()), sequenceInformation);
        }
    }

    @Override
    public TableInformation getTableInformation(Identifier catalogName, Identifier schemaName, Identifier tableName) {
        return this.getTableInformation(new QualifiedTableName(catalogName, schemaName, tableName));
    }

    @Override
    public TableInformation getTableInformation(Schema.Name schemaName, Identifier tableName) {
        return this.getTableInformation(new QualifiedTableName(schemaName, tableName));
    }

    @Override
    public TableInformation getTableInformation(QualifiedTableName qualifiedTableName) {
        if (qualifiedTableName.getObjectName() == null) {
            throw new IllegalArgumentException("Passed table name cannot be null");
        }
        TableInformation result = this.tableInformationMap.get(qualifiedTableName);
        if (result == null) {
            result = this.extractor.getTable(qualifiedTableName.getCatalogName(), qualifiedTableName.getSchemaName(), qualifiedTableName.getTableName());
        }
        return result;
    }

    @Override
    public SequenceInformation getSequenceInformation(Identifier catalogName, Identifier schemaName, Identifier sequenceName) {
        return this.getSequenceInformation(new QualifiedSequenceName(catalogName, schemaName, sequenceName));
    }

    @Override
    public SequenceInformation getSequenceInformation(Schema.Name schemaName, Identifier sequenceName) {
        return this.getSequenceInformation(new QualifiedSequenceName(schemaName, sequenceName));
    }

    @Override
    public SequenceInformation getSequenceInformation(QualifiedSequenceName qualifiedSequenceName) {
        return this.locateRegisteredSequenceInformation(qualifiedSequenceName);
    }

    @Override
    public TableInformation locateRegisteredTableInformation(QualifiedTableName tableName) {
        return this.tableInformationMap.get(tableName);
    }

    @Override
    public SequenceInformation locateRegisteredSequenceInformation(QualifiedSequenceName sequenceName) {
        if (sequenceName.getCatalogName() != null || sequenceName.getSchemaName() != null) {
            sequenceName = new QualifiedSequenceName(null, null, sequenceName.getSequenceName());
        }
        return this.sequenceInformationMap.get(sequenceName);
    }

    @Override
    public void registerTable(TableInformation tableInformation) {
        this.tableInformationMap.put(tableInformation.getName(), tableInformation);
    }

    private static class KnownNonExistentTableInformation
    implements TableInformation {
        private KnownNonExistentTableInformation() {
        }

        @Override
        public QualifiedTableName getName() {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public boolean isPhysicalTable() {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public String getComment() {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public Iterable<ColumnInformation> getColumns() {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public ColumnInformation getColumn(Identifier columnIdentifier) {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public PrimaryKeyInformation getPrimaryKey() {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public Iterable<ForeignKeyInformation> getForeignKeys() {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public ForeignKeyInformation getForeignKey(Identifier keyName) {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public Iterable<IndexInformation> getIndexes() {
            throw new UnsupportedOperationException("Table does not exist");
        }

        @Override
        public IndexInformation getIndex(Identifier indexName) {
            throw new UnsupportedOperationException("Table does not exist");
        }
    }
}

