/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;

public class SequenceInformationExtractorLegacyImpl
implements SequenceInformationExtractor {
    public static final SequenceInformationExtractorLegacyImpl INSTANCE = new SequenceInformationExtractorLegacyImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<SequenceInformation> extractMetadata(ExtractionContext extractionContext) throws SQLException {
        String lookupSql = extractionContext.getJdbcEnvironment().getDialect().getQuerySequencesString();
        if (lookupSql == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE.extractMetadata(extractionContext);
        }
        IdentifierHelper identifierHelper = extractionContext.getJdbcEnvironment().getIdentifierHelper();
        Statement statement = extractionContext.getJdbcConnection().createStatement();
        try {
            ArrayList<SequenceInformation> arrayList;
            ResultSet resultSet = statement.executeQuery(lookupSql);
            try {
                ArrayList<SequenceInformation> sequenceInformationList = new ArrayList<SequenceInformation>();
                while (resultSet.next()) {
                    sequenceInformationList.add(new SequenceInformationImpl(new QualifiedSequenceName(null, null, identifierHelper.fromMetaDataObjectName(resultSet.getString(1))), -1));
                }
                arrayList = sequenceInformationList;
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return arrayList;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

