/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.hibernate.JDBCException;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.tool.schema.extract.internal.ColumnInformationImpl;
import org.hibernate.tool.schema.extract.internal.ForeignKeyInformationImpl;
import org.hibernate.tool.schema.extract.internal.IndexInformationImpl;
import org.hibernate.tool.schema.extract.internal.PrimaryKeyInformationImpl;
import org.hibernate.tool.schema.extract.internal.TableInformationImpl;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.extract.spi.PrimaryKeyInformation;
import org.hibernate.tool.schema.extract.spi.SchemaExtractionException;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.spi.SchemaManagementException;

public class InformationExtractorJdbcDatabaseMetaDataImpl
implements InformationExtractor {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(InformationExtractorJdbcDatabaseMetaDataImpl.class);
    public static final String ALL_CATALOGS_FILTER = null;
    public static final String SANS_CATALOG_FILTER = "";
    public static final String ALL_SCHEMAS_FILTER = null;
    public static final String SANS_SCHEMA_FILTER = "";
    private final String[] tableTypes;
    private final ExtractionContext extractionContext;

    public InformationExtractorJdbcDatabaseMetaDataImpl(ExtractionContext extractionContext) {
        this.extractionContext = extractionContext;
        ConfigurationService configService = extractionContext.getServiceRegistry().getService(ConfigurationService.class);
        this.tableTypes = ConfigurationHelper.getBoolean("hibernate.synonyms", configService.getSettings(), false) ? new String[]{"TABLE", "VIEW", "SYNONYM"} : new String[]{"TABLE", "VIEW"};
    }

    protected IdentifierHelper identifierHelper() {
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper();
    }

    protected JDBCException convertSQLException(SQLException sqlException, String message) {
        return this.extractionContext.getJdbcEnvironment().getSqlExceptionHelper().convert(sqlException, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TableInformation> getTables(Identifier catalog, Identifier schema) {
        try {
            String catalogFilter = this.determineCatalogFilter(catalog);
            String schemaFilter = this.determineSchemaFilter(schema);
            ArrayList<TableInformation> results = new ArrayList<TableInformation>();
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getTables(catalogFilter, schemaFilter, null, this.tableTypes);
            try {
                while (resultSet.next()) {
                    TableInformation tableInformation = this.extractTableInformation(resultSet);
                    results.add(tableInformation);
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            return results;
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Error accessing table metadata");
        }
    }

    private String determineCatalogFilter(Identifier catalog) throws SQLException {
        Identifier identifierToUse = catalog;
        if (identifierToUse == null) {
            identifierToUse = this.extractionContext.getDefaultCatalog();
        }
        if (identifierToUse == null) {
            return "";
        }
        return this.determineAppropriateCapitalization(identifierToUse);
    }

    private String determineSchemaFilter(Identifier schema) throws SQLException {
        Identifier identifierToUse = schema;
        if (identifierToUse == null) {
            identifierToUse = this.extractionContext.getDefaultSchema();
        }
        if (identifierToUse == null) {
            return "";
        }
        return this.determineAppropriateCapitalization(identifierToUse);
    }

    private String determineAppropriateCapitalization(Identifier identifierToUse) throws SQLException {
        if (identifierToUse.isQuoted()) {
            if (this.extractionContext.getJdbcDatabaseMetaData().storesMixedCaseQuotedIdentifiers()) {
                return identifierToUse.getText();
            }
            if (this.extractionContext.getJdbcDatabaseMetaData().storesUpperCaseQuotedIdentifiers()) {
                return identifierToUse.getText().toUpperCase(Locale.ENGLISH);
            }
            if (this.extractionContext.getJdbcDatabaseMetaData().storesLowerCaseQuotedIdentifiers()) {
                return identifierToUse.getText().toLowerCase(Locale.ENGLISH);
            }
            return identifierToUse.getText();
        }
        if (this.extractionContext.getJdbcDatabaseMetaData().storesMixedCaseIdentifiers()) {
            return identifierToUse.getText();
        }
        if (this.extractionContext.getJdbcDatabaseMetaData().storesUpperCaseIdentifiers()) {
            return identifierToUse.getText().toUpperCase(Locale.ENGLISH);
        }
        if (this.extractionContext.getJdbcDatabaseMetaData().storesLowerCaseIdentifiers()) {
            return identifierToUse.getText().toLowerCase(Locale.ENGLISH);
        }
        return identifierToUse.getText();
    }

    public TableInformation extractTableInformation(ResultSet resultSet) throws SQLException {
        Identifier catalogIdentifier = this.identifierHelper().fromMetaDataCatalogName(resultSet.getString("TABLE_CAT"));
        Identifier schemaIdentifier = this.identifierHelper().fromMetaDataSchemaName(resultSet.getString("TABLE_SCHEM"));
        Identifier tableIdentifier = this.identifierHelper().fromMetaDataObjectName(resultSet.getString("TABLE_NAME"));
        QualifiedTableName tableName = new QualifiedTableName(new Schema.Name(catalogIdentifier, schemaIdentifier), tableIdentifier);
        return new TableInformationImpl(this, tableName, this.isPhysicalTableType(resultSet.getString("TABLE_TYPE")), resultSet.getString("REMARKS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableInformation getTable(Identifier catalog, Identifier schema, Identifier tableName) {
        try {
            String catalogFilter = this.determineCatalogFilter(catalog);
            String schemaFilter = this.determineSchemaFilter(schema);
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getTables(catalogFilter, schemaFilter, this.determineAppropriateCapitalization(tableName), this.tableTypes);
            try {
                if (!resultSet.next()) {
                    log.tableNotFound(tableName.render());
                    TableInformation tableInformation = null;
                    return tableInformation;
                }
                TableInformation tableInformation = this.extractTableInformation(resultSet);
                if (resultSet.next()) {
                    log.multipleTablesFound(tableName.render());
                }
                TableInformation tableInformation2 = tableInformation;
                return tableInformation2;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Error accessing table metadata");
        }
    }

    protected boolean isPhysicalTableType(String tableType) {
        return "TABLE".equalsIgnoreCase(tableType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ColumnInformation> getColumns(TableInformation tableInformation) {
        ArrayList<ColumnInformation> results = new ArrayList<ColumnInformation>();
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getColumns(this.identifierHelper().toMetaDataCatalogName(tableInformation.getName().getCatalogName()), this.identifierHelper().toMetaDataSchemaName(tableInformation.getName().getSchemaName()), this.identifierHelper().toMetaDataObjectName(tableInformation.getName().getTableName()), "%");
            try {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("COLUMN_NAME");
                    if (columnName == null) continue;
                    results.add(new ColumnInformationImpl(tableInformation, Identifier.toIdentifier(columnName), resultSet.getInt("DATA_TYPE"), new StringTokenizer(resultSet.getString("TYPE_NAME"), "() ").nextToken(), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), this.interpretTruthValue(resultSet.getString("IS_NULLABLE"))));
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing column metadata: " + tableInformation.getName().toString());
        }
        return results;
    }

    private TruthValue interpretTruthValue(String nullable) {
        if ("yes".equalsIgnoreCase(nullable)) {
            return TruthValue.TRUE;
        }
        if ("no".equalsIgnoreCase(nullable)) {
            return TruthValue.FALSE;
        }
        return TruthValue.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimaryKeyInformation getPrimaryKey(TableInformationImpl tableInformation) {
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getPrimaryKeys(this.identifierHelper().toMetaDataCatalogName(tableInformation.getName().getCatalogName()), this.identifierHelper().toMetaDataSchemaName(tableInformation.getName().getSchemaName()), this.identifierHelper().toMetaDataObjectName(tableInformation.getName().getTableName()));
            ArrayList<ColumnInformation> pkColumns = new ArrayList<ColumnInformation>();
            boolean firstPass = true;
            Identifier pkIdentifier = null;
            try {
                while (resultSet.next()) {
                    Identifier currentPkIdentifier;
                    String currentPkName = resultSet.getString("PK_NAME");
                    Identifier identifier = currentPkIdentifier = currentPkName == null ? null : this.identifierHelper().fromMetaDataObjectName(currentPkName);
                    if (firstPass) {
                        pkIdentifier = currentPkIdentifier;
                        firstPass = false;
                    } else if (!EqualsHelper.equals(pkIdentifier, currentPkIdentifier)) {
                        throw new SchemaExtractionException(String.format("Encountered primary keys differing name on table %s", tableInformation.getName().toString()));
                    }
                    int columnPosition = resultSet.getInt("KEY_SEQ");
                    String columnName = resultSet.getString("COLUMN_NAME");
                    Identifier columnIdentifier = this.identifierHelper().fromMetaDataObjectName(columnName);
                    ColumnInformation column = tableInformation.getColumn(columnIdentifier);
                    pkColumns.add(columnPosition - 1, column);
                }
            }
            finally {
                resultSet.close();
            }
            if (firstPass) {
                return null;
            }
            for (int i = 0; i < pkColumns.size(); ++i) {
                if (pkColumns.get(i) != null) continue;
                throw new SchemaExtractionException("Primary Key information was missing for KEY_SEQ = " + (i + 1));
            }
            return new PrimaryKeyInformationImpl(pkIdentifier, pkColumns);
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error while reading primary key meta data for " + tableInformation.getName().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IndexInformation> getIndexes(TableInformation tableInformation) {
        HashMap<Identifier, IndexInformationImpl.Builder> builders = new HashMap<Identifier, IndexInformationImpl.Builder>();
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getIndexInfo(this.identifierHelper().toMetaDataCatalogName(tableInformation.getName().getCatalogName()), this.identifierHelper().toMetaDataSchemaName(tableInformation.getName().getSchemaName()), this.identifierHelper().toMetaDataObjectName(tableInformation.getName().getTableName()), false, true);
            try {
                while (resultSet.next()) {
                    Identifier columnIdentifier;
                    ColumnInformation columnInformation;
                    if (resultSet.getShort("TYPE") == 0) continue;
                    Identifier indexIdentifier = Identifier.toIdentifier(resultSet.getString("INDEX_NAME"));
                    IndexInformationImpl.Builder builder = (IndexInformationImpl.Builder)builders.get(indexIdentifier);
                    if (builder == null) {
                        builder = IndexInformationImpl.builder(indexIdentifier);
                        builders.put(indexIdentifier, builder);
                    }
                    if ((columnInformation = tableInformation.getColumn(columnIdentifier = Identifier.toIdentifier(resultSet.getString("COLUMN_NAME")))) == null) {
                        throw new SchemaManagementException("Could not locate column information using identifier [" + columnIdentifier.getText() + "]");
                    }
                    builder.addColumn(columnInformation);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing index information: " + tableInformation.getName().toString());
        }
        ArrayList<IndexInformation> indexes = new ArrayList<IndexInformation>();
        for (IndexInformationImpl.Builder builder : builders.values()) {
            IndexInformationImpl index = builder.build();
            indexes.add(index);
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ForeignKeyInformation> getForeignKeys(TableInformation tableInformation) {
        HashMap<Identifier, ForeignKeyBuilder> fkBuilders = new HashMap<Identifier, ForeignKeyBuilder>();
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getImportedKeys(this.identifierHelper().toMetaDataCatalogName(tableInformation.getName().getCatalogName()), this.identifierHelper().toMetaDataSchemaName(tableInformation.getName().getSchemaName()), this.identifierHelper().toMetaDataObjectName(tableInformation.getName().getTableName()));
            try {
                while (resultSet.next()) {
                    Identifier fkIdentifier = Identifier.toIdentifier(resultSet.getString("FK_NAME"));
                    ForeignKeyBuilder fkBuilder = (ForeignKeyBuilder)fkBuilders.get(fkIdentifier);
                    if (fkBuilder == null) {
                        fkBuilder = this.generateForeignKeyBuilder(fkIdentifier);
                        fkBuilders.put(fkIdentifier, fkBuilder);
                    }
                    QualifiedTableName incomingPkTableName = this.extractKeyTableName(resultSet, "PK");
                    TableInformation pkTableInformation = this.extractionContext.getRegisteredObjectAccess().locateRegisteredTableInformation(incomingPkTableName);
                    if (pkTableInformation == null) continue;
                    Identifier fkColumnIdentifier = Identifier.toIdentifier(resultSet.getString("FKCOLUMN_NAME"));
                    Identifier pkColumnIdentifier = Identifier.toIdentifier(resultSet.getString("PKCOLUMN_NAME"));
                    fkBuilder.addColumnMapping(tableInformation.getColumn(fkColumnIdentifier), pkTableInformation.getColumn(pkColumnIdentifier));
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing column metadata: " + tableInformation.getName().toString());
        }
        ArrayList<ForeignKeyInformation> fks = new ArrayList<ForeignKeyInformation>();
        for (ForeignKeyBuilder fkBuilder : fkBuilders.values()) {
            ForeignKeyInformation fk = fkBuilder.build();
            fks.add(fk);
        }
        return fks;
    }

    private ForeignKeyBuilder generateForeignKeyBuilder(Identifier fkIdentifier) {
        return new ForeignKeyBuilderImpl(fkIdentifier);
    }

    private QualifiedTableName extractKeyTableName(ResultSet resultSet, String prefix) throws SQLException {
        String incomingCatalogName = resultSet.getString(prefix + "TABLE_SCHEM");
        String incomingSchemaName = resultSet.getString(prefix + "TABLE_CATALOG");
        String incomingTableName = resultSet.getString(prefix + "TABLE_NAME");
        return new QualifiedTableName(new Schema.Name(Identifier.toIdentifier(incomingCatalogName), Identifier.toIdentifier(incomingSchemaName)), Identifier.toIdentifier(incomingTableName));
    }

    protected static class ForeignKeyBuilderImpl
    implements ForeignKeyBuilder {
        private final Identifier fkIdentifier;
        private final List<ForeignKeyInformation.ColumnReferenceMapping> columnMappingList = new ArrayList<ForeignKeyInformation.ColumnReferenceMapping>();

        public ForeignKeyBuilderImpl(Identifier fkIdentifier) {
            this.fkIdentifier = fkIdentifier;
        }

        @Override
        public ForeignKeyBuilder addColumnMapping(ColumnInformation referencing, ColumnInformation referenced) {
            this.columnMappingList.add(new ForeignKeyInformationImpl.ColumnReferenceMappingImpl(referencing, referenced));
            return this;
        }

        @Override
        public ForeignKeyInformationImpl build() {
            if (this.columnMappingList.isEmpty()) {
                throw new SchemaManagementException("Attempt to resolve foreign key metadata from JDBC metadata failed to find column mappings for foreign key named [" + this.fkIdentifier.getText() + "]");
            }
            return new ForeignKeyInformationImpl(this.fkIdentifier, this.columnMappingList);
        }
    }

    protected static interface ForeignKeyBuilder {
        public ForeignKeyBuilder addColumnMapping(ColumnInformation var1, ColumnInformation var2);

        public ForeignKeyInformation build();
    }
}

