/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;

public class DatabaseInformationImpl
implements DatabaseInformation,
ExtractionContext.RegisteredObjectAccess {
    private final Map<QualifiedTableName, TableInformation> tableInformationMap = new HashMap<QualifiedTableName, TableInformation>();
    private final Map<QualifiedSequenceName, SequenceInformation> sequenceInformationMap = new HashMap<QualifiedSequenceName, SequenceInformation>();

    @Override
    public TableInformation getTableInformation(Identifier catalogName, Identifier schemaName, Identifier tableName) {
        return this.locateRegisteredTableInformation(new QualifiedTableName(catalogName, schemaName, tableName));
    }

    @Override
    public TableInformation getTableInformation(Schema.Name schemaName, Identifier tableName) {
        return this.locateRegisteredTableInformation(new QualifiedTableName(schemaName, tableName));
    }

    @Override
    public TableInformation getTableInformation(QualifiedTableName tableName) {
        return this.locateRegisteredTableInformation(tableName);
    }

    @Override
    public SequenceInformation getSequenceInformation(Identifier catalogName, Identifier schemaName, Identifier sequenceName) {
        return this.locateRegisteredSequenceInformation(new QualifiedSequenceName(catalogName, schemaName, sequenceName));
    }

    @Override
    public SequenceInformation getSequenceInformation(Schema.Name schemaName, Identifier sequenceName) {
        return this.locateRegisteredSequenceInformation(new QualifiedSequenceName(schemaName, sequenceName));
    }

    @Override
    public SequenceInformation getSequenceInformation(QualifiedSequenceName sequenceName) {
        return this.locateRegisteredSequenceInformation(sequenceName);
    }

    public void registerTableInformation(TableInformation tableInformation) {
        this.tableInformationMap.put(tableInformation.getName(), tableInformation);
    }

    public void registerSequenceInformation(SequenceInformation sequenceInformation) {
        this.sequenceInformationMap.put(sequenceInformation.getSequenceName(), sequenceInformation);
    }

    @Override
    public TableInformation locateRegisteredTableInformation(QualifiedTableName tableName) {
        return this.tableInformationMap.get(tableName);
    }

    @Override
    public SequenceInformation locateRegisteredSequenceInformation(QualifiedSequenceName sequenceName) {
        return this.sequenceInformationMap.get(sequenceName);
    }

    @Override
    public void registerTable(TableInformation tableInformation) {
        this.tableInformationMap.put(tableInformation.getName(), tableInformation);
    }
}

