/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.Service;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.StandardSessionFactoryServiceInitiators;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class SessionFactoryServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements SessionFactoryServiceRegistry {
    private final SessionFactory.SessionFactoryOptions sessionFactoryOptions;
    private final SessionFactoryImplementor sessionFactory;

    public SessionFactoryServiceRegistryImpl(ServiceRegistryImplementor parent, SessionFactoryImplementor sessionFactory, SessionFactory.SessionFactoryOptions sessionFactoryOptions) {
        super(parent);
        this.sessionFactory = sessionFactory;
        this.sessionFactoryOptions = sessionFactoryOptions;
        for (SessionFactoryServiceInitiator initiator : StandardSessionFactoryServiceInitiators.LIST) {
            this.createServiceBinding(initiator);
        }
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        SessionFactoryServiceInitiator sessionFactoryServiceInitiator = (SessionFactoryServiceInitiator)serviceInitiator;
        return sessionFactoryServiceInitiator.initiateService(this.sessionFactory, this.sessionFactoryOptions, this);
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
    }
}

