/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.ExportableColumn;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class TableGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TableGenerator.class.getName());
    public static final String CONFIG_PREFER_SEGMENT_PER_ENTITY = "prefer_entity_table_as_segment_value";
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    private Type identifierType;
    private QualifiedName qualifiedTableName;
    private String renderedTableName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private String valueColumnName;
    private int initialValue;
    private int incrementSize;
    private String selectQuery;
    private String insertQuery;
    private String updateQuery;
    private Optimizer optimizer;
    private long accessCount;

    @Override
    public Object generatorKey() {
        return this.qualifiedTableName.render();
    }

    public final Type getIdentifierType() {
        return this.identifierType;
    }

    public final String getTableName() {
        return this.qualifiedTableName.render();
    }

    public final String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public final String getSegmentValue() {
        return this.segmentValue;
    }

    public final int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public final String getValueColumnName() {
        return this.valueColumnName;
    }

    public final int getInitialValue() {
        return this.initialValue;
    }

    public final int getIncrementSize() {
        return this.incrementSize;
    }

    public final Optimizer getOptimizer() {
        return this.optimizer;
    }

    public final long getTableAccessCount() {
        return this.accessCount;
    }

    @Override
    public void configure(Type type, Properties params, JdbcEnvironment jdbcEnv) throws MappingException {
        this.identifierType = type;
        Dialect dialect = jdbcEnv.getDialect();
        this.qualifiedTableName = this.determineGeneratorTableName(params, dialect);
        this.renderedTableName = jdbcEnv.getQualifiedObjectNameFormatter().format(this.qualifiedTableName, dialect);
        this.segmentColumnName = this.determineSegmentColumnName(params, dialect);
        this.valueColumnName = this.determineValueColumnName(params, dialect);
        this.segmentValue = this.determineSegmentValue(params);
        this.segmentValueLength = this.determineSegmentColumnSize(params);
        this.initialValue = this.determineInitialValue(params);
        this.incrementSize = this.determineIncrementSize(params);
        this.selectQuery = this.buildSelectQuery(dialect);
        this.updateQuery = this.buildUpdateQuery();
        this.insertQuery = this.buildInsertQuery();
        String defaultPooledOptimizerStrategy = ConfigurationHelper.getBoolean("hibernate.id.optimizer.pooled.prefer_lo", params, false) ? StandardOptimizerDescriptor.POOLED_LO.getExternalName() : StandardOptimizerDescriptor.POOLED.getExternalName();
        String defaultOptimizerStrategy = this.incrementSize <= 1 ? StandardOptimizerDescriptor.NONE.getExternalName() : defaultPooledOptimizerStrategy;
        String optimizationStrategy = ConfigurationHelper.getString(OPT_PARAM, params, defaultOptimizerStrategy);
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), this.incrementSize, ConfigurationHelper.getInt(INITIAL_PARAM, params, -1));
    }

    protected QualifiedName determineGeneratorTableName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        return QualifiedNameParser.INSTANCE.parse(ConfigurationHelper.getString(TABLE_PARAM, params, DEF_TABLE), normalizer.normalizeIdentifierQuoting(params.getProperty("catalog")), normalizer.normalizeIdentifierQuoting(params.getProperty("schema")));
    }

    protected String determineSegmentColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = ConfigurationHelper.getString(SEGMENT_COLUMN_PARAM, params, DEF_SEGMENT_COLUMN);
        return normalizer.toDatabaseIdentifierText(name);
    }

    protected String determineValueColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = ConfigurationHelper.getString(VALUE_COLUMN_PARAM, params, DEF_VALUE_COLUMN);
        return normalizer.toDatabaseIdentifierText(name);
    }

    protected String determineSegmentValue(Properties params) {
        String segmentValue = params.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty(segmentValue)) {
            segmentValue = this.determineDefaultSegmentValue(params);
        }
        return segmentValue;
    }

    protected String determineDefaultSegmentValue(Properties params) {
        boolean preferSegmentPerEntity = ConfigurationHelper.getBoolean(CONFIG_PREFER_SEGMENT_PER_ENTITY, params, false);
        String defaultToUse = preferSegmentPerEntity ? params.getProperty("target_table") : DEF_SEGMENT_VALUE;
        LOG.usingDefaultIdGeneratorSegmentValue(this.qualifiedTableName.render(), this.segmentColumnName, defaultToUse);
        return defaultToUse;
    }

    protected int determineSegmentColumnSize(Properties params) {
        return ConfigurationHelper.getInt(SEGMENT_LENGTH_PARAM, params, 255);
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt(INITIAL_PARAM, params, 1);
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt(INCREMENT_PARAM, params, 1);
    }

    protected String buildSelectQuery(Dialect dialect) {
        String alias = "tbl";
        String query = "select " + StringHelper.qualify("tbl", this.valueColumnName) + " from " + this.renderedTableName + ' ' + "tbl" + " where " + StringHelper.qualify("tbl", this.segmentColumnName) + "=?";
        LockOptions lockOptions = new LockOptions(LockMode.PESSIMISTIC_WRITE);
        lockOptions.setAliasSpecificLockMode("tbl", LockMode.PESSIMISTIC_WRITE);
        Map<String, String[]> updateTargetColumnsMap = Collections.singletonMap("tbl", new String[]{this.valueColumnName});
        return dialect.applyLocksToSql(query, lockOptions, updateTargetColumnsMap);
    }

    protected String buildUpdateQuery() {
        return "update " + this.renderedTableName + " set " + this.valueColumnName + "=? " + " where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
    }

    protected String buildInsertQuery() {
        return "insert into " + this.renderedTableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ") " + " values (?,?)";
    }

    private IntegralDataTypeHolder makeValue() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }

    @Override
    public Serializable generate(final SessionImplementor session, Object obj) {
        final SqlStatementLogger statementLogger = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlStatementLogger();
        final SessionEventListenerManager statsCollector = session.getEventListenerManager();
        return this.optimizer.generate(new AccessCallback(){

            @Override
            public IntegralDataTypeHolder getNextValue() {
                return session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int rows;
                        IntegralDataTypeHolder value = TableGenerator.this.makeValue();
                        do {
                            PreparedStatement selectPS = TableGenerator.this.prepareStatement(connection, TableGenerator.this.selectQuery, statementLogger, statsCollector);
                            try {
                                selectPS.setString(1, TableGenerator.this.segmentValue);
                                ResultSet selectRS = TableGenerator.this.executeQuery(selectPS, statsCollector);
                                if (!selectRS.next()) {
                                    value.initialize(TableGenerator.this.initialValue);
                                    PreparedStatement insertPS = TableGenerator.this.prepareStatement(connection, TableGenerator.this.insertQuery, statementLogger, statsCollector);
                                    try {
                                        insertPS.setString(1, TableGenerator.this.segmentValue);
                                        value.bind(insertPS, 2);
                                        TableGenerator.this.executeUpdate(insertPS, statsCollector);
                                    }
                                    finally {
                                        insertPS.close();
                                    }
                                } else {
                                    value.initialize(selectRS, 1L);
                                }
                                selectRS.close();
                            }
                            catch (SQLException e) {
                                LOG.unableToReadOrInitHiValue(e);
                                throw e;
                            }
                            finally {
                                selectPS.close();
                            }
                            PreparedStatement updatePS = TableGenerator.this.prepareStatement(connection, TableGenerator.this.updateQuery, statementLogger, statsCollector);
                            try {
                                IntegralDataTypeHolder updateValue = value.copy();
                                if (TableGenerator.this.optimizer.applyIncrementSizeToSourceValues()) {
                                    updateValue.add(TableGenerator.this.incrementSize);
                                } else {
                                    updateValue.increment();
                                }
                                updateValue.bind(updatePS, 1);
                                value.bind(updatePS, 2);
                                updatePS.setString(3, TableGenerator.this.segmentValue);
                                rows = TableGenerator.this.executeUpdate(updatePS, statsCollector);
                            }
                            catch (SQLException e) {
                                LOG.unableToUpdateQueryHiValue(TableGenerator.this.renderedTableName, e);
                                throw e;
                            }
                            finally {
                                updatePS.close();
                            }
                        } while (rows == 0);
                        TableGenerator.this.accessCount++;
                        return value;
                    }
                }, true);
            }

            @Override
            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(Connection connection, String sql, SqlStatementLogger statementLogger, SessionEventListenerManager statsCollector) throws SQLException {
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
        try {
            statsCollector.jdbcPrepareStatementStart();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement;
        }
        finally {
            statsCollector.jdbcPrepareStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + ' ' + this.renderedTableName + " ( " + this.segmentColumnName + ' ' + dialect.getTypeName(12, this.segmentValueLength, 0, 0) + " not null " + ", " + this.valueColumnName + ' ' + dialect.getTypeName(-5) + ", primary key ( " + this.segmentColumnName + " ) )" + dialect.getTableTypeString()};
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getDropTableString(this.renderedTableName)};
    }

    @Override
    public void registerExportables(Database database) {
        Dialect dialect = database.getJdbcEnvironment().getDialect();
        Schema schema = database.locateSchema(this.qualifiedTableName.getCatalogName(), this.qualifiedTableName.getSchemaName());
        Table table = schema.createTable(this.qualifiedTableName.getObjectName(), false);
        ExportableColumn segmentColumn = new ExportableColumn(database, table, this.segmentColumnName, StringType.INSTANCE, dialect.getTypeName(12, this.segmentValueLength, 0, 0));
        segmentColumn.setNullable(false);
        table.addColumn(segmentColumn);
        table.setPrimaryKey(new PrimaryKey());
        table.getPrimaryKey().setTable(table);
        table.getPrimaryKey().addColumn(segmentColumn);
        ExportableColumn valueColumn = new ExportableColumn(database, table, this.valueColumnName, LongType.INSTANCE);
        table.addColumn(valueColumn);
    }
}

