/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.boot.model.relational.SimpleAuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

@Deprecated
public class SequenceGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
Configurable {
    private static final Logger LOG = Logger.getLogger((String)SequenceGenerator.class.getName());
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private QualifiedName qualifiedSequenceName;
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;

    protected Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public Object generatorKey() {
        return this.getSequenceName();
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public void configure(Type type, Properties params, JdbcEnvironment jdbcEnv) throws MappingException {
        this.identifierType = type;
        this.parameters = params.getProperty(PARAMETERS);
        Dialect dialect = jdbcEnv.getDialect();
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        this.qualifiedSequenceName = QualifiedNameParser.INSTANCE.parse(ConfigurationHelper.getString(SEQUENCE, params, "hibernate_sequence"), normalizer.normalizeIdentifierQuoting(params.getProperty("catalog")), normalizer.normalizeIdentifierQuoting(params.getProperty("schema")));
        this.sequenceName = jdbcEnv.getQualifiedObjectNameFormatter().format(this.qualifiedSequenceName, dialect);
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    @Override
    public Serializable generate(SessionImplementor session, Object obj) {
        return this.generateHolder(session).makeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected IntegralDataTypeHolder generateHolder(SessionImplementor session) {
        try {
            PreparedStatement st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
            try {
                ResultSet rs = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(st);
                try {
                    rs.next();
                    IntegralDataTypeHolder result = this.buildHolder();
                    result.initialize(rs, 1L);
                    LOG.debugf("Sequence identifier generated: %s", (Object)result);
                    IntegralDataTypeHolder integralDataTypeHolder = result;
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
                    return integralDataTypeHolder;
                }
                catch (Throwable throwable) {
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
                    throw throwable;
                }
            }
            finally {
                session.getTransactionCoordinator().getJdbcCoordinator().release(st);
            }
        }
        catch (SQLException sqle) {
            throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not get next sequence value", this.sql);
        }
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] ddl = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = ddl.length - 1;
            ddl[n] = ddl[n] + ' ' + this.parameters;
        }
        return ddl;
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    @Override
    public boolean supportsBulkInsertionIdentifierGeneration() {
        return true;
    }

    @Override
    public String determineBulkInsertionIdentifierGenerationSelectFragment(Dialect dialect) {
        return dialect.getSelectSequenceNextValString(this.getSequenceName());
    }

    @Override
    public void registerExportables(Database database) {
        Schema schema = database.locateSchema(this.qualifiedSequenceName.getCatalogName(), this.qualifiedSequenceName.getSchemaName());
        database.addAuxiliaryDatabaseObject(new SimpleAuxiliaryDatabaseObject(schema, this.sqlCreateStrings(database.getDialect()), this.sqlDropStrings(database.getDialect()), Collections.<String>emptySet()));
    }
}

