/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;

public class QualifiedObjectNameFormatterStandardImpl
implements QualifiedObjectNameFormatter {
    private final String catalogSeparator;
    private final boolean catalogAtEnd;

    public QualifiedObjectNameFormatterStandardImpl(DatabaseMetaData databaseMetaData) throws SQLException {
        this(databaseMetaData.getCatalogSeparator(), !databaseMetaData.isCatalogAtStart());
    }

    public QualifiedObjectNameFormatterStandardImpl(String catalogSeparator, boolean catalogAtEnd) {
        this.catalogSeparator = catalogSeparator;
        this.catalogAtEnd = catalogAtEnd;
    }

    public QualifiedObjectNameFormatterStandardImpl() {
        this(".", false);
    }

    @Override
    public String format(QualifiedTableName qualifiedTableName, Dialect dialect) {
        return this.format(this.render(qualifiedTableName.getCatalogName(), dialect), this.render(qualifiedTableName.getSchemaName(), dialect), this.render(qualifiedTableName.getTableName(), dialect));
    }

    private String format(String catalogName, String schemaName, String objectName) {
        StringBuilder buff = new StringBuilder();
        if (!this.catalogAtEnd && catalogName != null) {
            buff.append(catalogName).append(this.catalogSeparator);
        }
        if (schemaName != null) {
            buff.append(schemaName).append('.');
        }
        buff.append(objectName);
        if (this.catalogAtEnd && catalogName != null) {
            buff.append(this.catalogSeparator).append(catalogName);
        }
        return buff.toString();
    }

    private String render(Identifier identifier, Dialect dialect) {
        if (identifier == null) {
            return null;
        }
        return identifier.render(dialect);
    }

    @Override
    public String format(QualifiedSequenceName qualifiedSequenceName, Dialect dialect) {
        return this.format(this.render(qualifiedSequenceName.getCatalogName(), dialect), this.render(qualifiedSequenceName.getSchemaName(), dialect), this.render(qualifiedSequenceName.getSequenceName(), dialect));
    }

    @Override
    public String format(QualifiedName qualifiedName, Dialect dialect) {
        return this.format(this.render(qualifiedName.getCatalogName(), dialect), this.render(qualifiedName.getSchemaName(), dialect), this.render(qualifiedName.getObjectName(), dialect));
    }
}

