/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class NormalizingIdentifierHelperImpl
implements IdentifierHelper {
    private static final Logger log = Logger.getLogger(NormalizingIdentifierHelperImpl.class);
    private final JdbcEnvironment jdbcEnvironment;
    private final boolean globallyQuoteIdentifiers;
    private final boolean storesMixedCaseQuotedIdentifiers;
    private final boolean storesLowerCaseQuotedIdentifiers;
    private final boolean storesUpperCaseQuotedIdentifiers;
    private final boolean storesUpperCaseIdentifiers;
    private final boolean storesLowerCaseIdentifiers;

    public NormalizingIdentifierHelperImpl(JdbcEnvironment jdbcEnvironment, boolean globallyQuoteIdentifiers, boolean storesMixedCaseQuotedIdentifiers, boolean storesLowerCaseQuotedIdentifiers, boolean storesUpperCaseQuotedIdentifiers, boolean storesUpperCaseIdentifiers, boolean storesLowerCaseIdentifiers) {
        this.jdbcEnvironment = jdbcEnvironment;
        this.globallyQuoteIdentifiers = globallyQuoteIdentifiers;
        this.storesMixedCaseQuotedIdentifiers = storesMixedCaseQuotedIdentifiers;
        this.storesLowerCaseQuotedIdentifiers = storesLowerCaseQuotedIdentifiers;
        this.storesUpperCaseQuotedIdentifiers = storesUpperCaseQuotedIdentifiers;
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
        if (storesMixedCaseQuotedIdentifiers && storesLowerCaseQuotedIdentifiers && storesUpperCaseQuotedIdentifiers) {
            log.warn((Object)"JDBC Driver reports it stores quoted identifiers in mixed, upper and lower case");
        } else if (storesMixedCaseQuotedIdentifiers && storesUpperCaseQuotedIdentifiers) {
            log.warn((Object)"JDBC Driver reports it stores quoted identifiers in both mixed and upper case");
        } else if (storesMixedCaseQuotedIdentifiers && storesLowerCaseQuotedIdentifiers) {
            log.warn((Object)"JDBC Driver reports it stores quoted identifiers in both mixed and lower case");
        }
        if (storesUpperCaseIdentifiers && storesLowerCaseIdentifiers) {
            log.warn((Object)"JDBC Driver reports it stores non-quoted identifiers in both upper and lower case");
        }
        if (storesUpperCaseIdentifiers && storesUpperCaseQuotedIdentifiers) {
            log.warn((Object)"JDBC Driver reports it stores both quoted and non-quoted identifiers in upper case");
        }
        if (storesLowerCaseIdentifiers && storesLowerCaseQuotedIdentifiers) {
            log.warn((Object)"JDBC Driver reports it stores both quoted and non-quoted identifiers in lower case");
        }
    }

    @Override
    public Identifier normalizeQuoting(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.isQuoted()) {
            return identifier;
        }
        if (this.globallyQuoteIdentifiers) {
            return Identifier.toIdentifier(identifier.getText(), true);
        }
        if (this.jdbcEnvironment.isReservedWord(identifier.getText())) {
            return Identifier.toIdentifier(identifier.getText(), true);
        }
        return identifier;
    }

    @Override
    public Identifier toIdentifier(String text) {
        return this.normalizeQuoting(Identifier.toIdentifier(text));
    }

    @Override
    public Identifier toIdentifier(String text, boolean quoted) {
        return this.normalizeQuoting(Identifier.toIdentifier(text, quoted));
    }

    @Override
    public String toMetaDataCatalogName(Identifier identifier) {
        if (identifier == null) {
            return this.jdbcEnvironment.getCurrentCatalog() == null ? null : this.jdbcEnvironment.getCurrentCatalog().render(this.jdbcEnvironment.getDialect());
        }
        return this.toMetaDataText(identifier);
    }

    private String toMetaDataText(Identifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier cannot be null; bad usage");
        }
        if (identifier.isQuoted() && this.storesMixedCaseQuotedIdentifiers) {
            return identifier.getText();
        }
        if (identifier.isQuoted() && this.storesUpperCaseQuotedIdentifiers || !identifier.isQuoted() && this.storesUpperCaseIdentifiers) {
            return StringHelper.toUpperCase(identifier.getText());
        }
        if (identifier.isQuoted() && this.storesLowerCaseQuotedIdentifiers || !identifier.isQuoted() && this.storesLowerCaseIdentifiers) {
            return StringHelper.toLowerCase(identifier.getText());
        }
        return identifier.getText();
    }

    @Override
    public String toMetaDataSchemaName(Identifier identifier) {
        if (identifier == null) {
            return this.jdbcEnvironment.getCurrentSchema() == null ? null : this.jdbcEnvironment.getCurrentSchema().getText();
        }
        return this.toMetaDataText(identifier);
    }

    @Override
    public String toMetaDataObjectName(Identifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("null was passed as an object name");
        }
        return this.toMetaDataText(identifier);
    }

    @Override
    public Identifier fromMetaDataCatalogName(String catalogName) {
        if (catalogName == null) {
            return null;
        }
        if (this.jdbcEnvironment.getCurrentCatalog() == null || catalogName.equals(this.jdbcEnvironment.getCurrentCatalog().getText())) {
            return null;
        }
        return this.toIdentifierFromMetaData(catalogName);
    }

    public Identifier toIdentifierFromMetaData(String text) {
        boolean isMixedCase;
        if (this.globallyQuoteIdentifiers) {
            return Identifier.toIdentifier(text, true);
        }
        boolean isUpperCase = text.toUpperCase().equals(text);
        boolean isLowerCase = text.toLowerCase().equals(text);
        boolean bl = isMixedCase = !isLowerCase && !isUpperCase;
        if (this.jdbcEnvironment.isReservedWord(text)) {
            return Identifier.toIdentifier(text, true);
        }
        if (this.storesMixedCaseQuotedIdentifiers && isMixedCase) {
            return Identifier.toIdentifier(text, true);
        }
        if (this.storesLowerCaseQuotedIdentifiers && isLowerCase) {
            return Identifier.toIdentifier(text, true);
        }
        if (this.storesUpperCaseQuotedIdentifiers && isUpperCase) {
            return Identifier.toIdentifier(text, true);
        }
        return Identifier.toIdentifier(text);
    }

    @Override
    public Identifier fromMetaDataSchemaName(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        if (this.jdbcEnvironment.getCurrentSchema() == null || schemaName.equals(this.jdbcEnvironment.getCurrentSchema().getText())) {
            return null;
        }
        return this.toIdentifier(schemaName);
    }

    @Override
    public Identifier fromMetaDataObjectName(String objectName) {
        if (objectName == null) {
            return null;
        }
        return this.toIdentifier(objectName);
    }
}

