/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.internal.ExtractedDatabaseMetaDataImpl;
import org.hibernate.engine.jdbc.env.internal.LobCreatorBuilderImpl;
import org.hibernate.engine.jdbc.env.internal.NormalizingIdentifierHelperImpl;
import org.hibernate.engine.jdbc.env.internal.QualifiedObjectNameFormatterStandardImpl;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.LobCreatorBuilder;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.TypeInfo;
import org.hibernate.exception.internal.SQLExceptionTypeDelegate;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.exception.internal.StandardSQLExceptionConverter;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class JdbcEnvironmentImpl
implements JdbcEnvironment {
    private final Dialect dialect;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final ExtractedDatabaseMetaData extractedMetaDataSupport;
    private final Identifier currentCatalog;
    private final Identifier currentSchema;
    private final IdentifierHelper identifierHelper;
    private final QualifiedObjectNameFormatter qualifiedObjectNameFormatter;
    private final LobCreatorBuilderImpl lobCreatorBuilder;
    private final LinkedHashSet<TypeInfo> typeInfoSet = new LinkedHashSet();
    private final Set<String> reservedWords = new HashSet<String>();
    public static final String SCHEMA_NAME_RESOLVER = "hibernate.schema_name_resolver";

    public JdbcEnvironmentImpl(ServiceRegistryImplementor serviceRegistry, Dialect dialect) {
        this.dialect = dialect;
        this.sqlExceptionHelper = this.buildSqlExceptionHelper(dialect);
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl.Builder(this).build();
        for (String keyword : dialect.getKeywords()) {
            this.reservedWords.add(keyword.toUpperCase());
        }
        boolean globallyQuoteIdentifiers = serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.globally_quoted_identifiers", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        this.identifierHelper = new NormalizingIdentifierHelperImpl(this, globallyQuoteIdentifiers, true, false, false, true, false);
        this.currentCatalog = this.identifierHelper.toIdentifier(serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.default_catalog", StandardConverters.STRING));
        this.currentSchema = Identifier.toIdentifier(serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.default_schema", StandardConverters.STRING));
        this.qualifiedObjectNameFormatter = new QualifiedObjectNameFormatterStandardImpl();
        this.lobCreatorBuilder = LobCreatorBuilderImpl.makeLobCreatorBuilder();
    }

    public JdbcEnvironmentImpl(DatabaseMetaData databaseMetaData, Dialect dialect) throws SQLException {
        this.dialect = dialect;
        this.sqlExceptionHelper = this.buildSqlExceptionHelper(dialect);
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl.Builder(this).apply(databaseMetaData).build();
        for (String keyword : dialect.getKeywords()) {
            this.reservedWords.add(keyword.toUpperCase());
        }
        this.reservedWords.addAll(this.extractedMetaDataSupport.getExtraKeywords());
        boolean globallyQuoteIdentifiers = false;
        this.identifierHelper = new NormalizingIdentifierHelperImpl(this, false, true, false, false, true, false);
        this.currentCatalog = null;
        this.currentSchema = null;
        this.qualifiedObjectNameFormatter = new QualifiedObjectNameFormatterStandardImpl(databaseMetaData);
        this.lobCreatorBuilder = LobCreatorBuilderImpl.makeLobCreatorBuilder();
    }

    public JdbcEnvironmentImpl(ServiceRegistryImplementor serviceRegistry, Dialect dialect, DatabaseMetaData databaseMetaData) throws SQLException {
        this.dialect = dialect;
        this.sqlExceptionHelper = this.buildSqlExceptionHelper(dialect);
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl.Builder(this).apply(databaseMetaData).setConnectionSchemaName(this.determineCurrentSchemaName(databaseMetaData, serviceRegistry, dialect)).build();
        for (String keyword : dialect.getKeywords()) {
            this.reservedWords.add(keyword.toUpperCase());
        }
        this.reservedWords.addAll(this.extractedMetaDataSupport.getExtraKeywords());
        boolean globallyQuoteIdentifiers = serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.globally_quoted_identifiers", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        this.identifierHelper = new NormalizingIdentifierHelperImpl(this, globallyQuoteIdentifiers, databaseMetaData.storesMixedCaseQuotedIdentifiers(), databaseMetaData.storesLowerCaseQuotedIdentifiers(), databaseMetaData.storesUpperCaseQuotedIdentifiers(), databaseMetaData.storesUpperCaseIdentifiers(), databaseMetaData.storesLowerCaseIdentifiers());
        this.currentCatalog = this.identifierHelper.toIdentifier(this.extractedMetaDataSupport.getConnectionCatalogName());
        this.currentSchema = this.identifierHelper.toIdentifier(this.extractedMetaDataSupport.getConnectionSchemaName());
        this.qualifiedObjectNameFormatter = new QualifiedObjectNameFormatterStandardImpl(databaseMetaData);
        this.typeInfoSet.addAll(TypeInfo.extractTypeInfo(databaseMetaData));
        this.lobCreatorBuilder = LobCreatorBuilderImpl.makeLobCreatorBuilder(serviceRegistry.getService(ConfigurationService.class).getSettings(), databaseMetaData.getConnection());
    }

    private String determineCurrentSchemaName(DatabaseMetaData databaseMetaData, ServiceRegistry serviceRegistry, Dialect dialect) throws SQLException {
        Object setting = serviceRegistry.getService(ConfigurationService.class).getSettings().get(SCHEMA_NAME_RESOLVER);
        SchemaNameResolver schemaNameResolver = setting == null ? dialect.getSchemaNameResolver() : serviceRegistry.getService(StrategySelector.class).resolveDefaultableStrategy(SchemaNameResolver.class, setting, dialect.getSchemaNameResolver());
        try {
            return schemaNameResolver.resolveSchemaName(databaseMetaData.getConnection(), dialect);
        }
        catch (Exception e) {
            return null;
        }
    }

    private SqlExceptionHelper buildSqlExceptionHelper(Dialect dialect) {
        StandardSQLExceptionConverter sqlExceptionConverter = new StandardSQLExceptionConverter();
        sqlExceptionConverter.addDelegate(dialect.buildSQLExceptionConversionDelegate());
        sqlExceptionConverter.addDelegate(new SQLExceptionTypeDelegate(dialect));
        sqlExceptionConverter.addDelegate(new SQLStateConversionDelegate(dialect));
        return new SqlExceptionHelper(sqlExceptionConverter);
    }

    private Set<String> buildMergedReservedWords(Dialect dialect, DatabaseMetaData dbmd) throws SQLException {
        HashSet<String> reservedWords = new HashSet<String>();
        reservedWords.addAll(dialect.getKeywords());
        reservedWords.addAll(Arrays.asList(dbmd.getSQLKeywords().split(",")));
        return reservedWords;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public ExtractedDatabaseMetaData getExtractedDatabaseMetaData() {
        return this.extractedMetaDataSupport;
    }

    @Override
    public Identifier getCurrentCatalog() {
        return this.currentCatalog;
    }

    @Override
    public Identifier getCurrentSchema() {
        return this.currentSchema;
    }

    @Override
    public QualifiedObjectNameFormatter getQualifiedObjectNameFormatter() {
        return this.qualifiedObjectNameFormatter;
    }

    @Override
    public IdentifierHelper getIdentifierHelper() {
        return this.identifierHelper;
    }

    @Override
    public boolean isReservedWord(String word) {
        return this.reservedWords.contains(word.toUpperCase());
    }

    @Override
    public SqlExceptionHelper getSqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public LobCreatorBuilder getLobCreatorBuilder() {
        return this.lobCreatorBuilder;
    }

    @Override
    public TypeInfo getTypeInfoForJdbcCode(int jdbcTypeCode) {
        for (TypeInfo typeInfo : this.typeInfoSet) {
            if (typeInfo.getJdbcTypeCode() != jdbcTypeCode) continue;
            return typeInfo;
        }
        return null;
    }
}

