/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jboss.logging.Logger;

public class EntityEntryContext {
    private static final Logger log = Logger.getLogger(EntityEntryContext.class);
    private transient ManagedEntity head;
    private transient ManagedEntity tail;
    private transient int count;
    private transient IdentityHashMap<Object, ManagedEntity> nonEnhancedEntityXref;
    private transient Map.Entry<Object, EntityEntry>[] reentrantSafeEntries = new Map.Entry[0];
    private transient boolean dirty;

    public void addEntityEntry(Object entity, EntityEntry entityEntry) {
        boolean alreadyAssociated;
        ManagedEntity managedEntity;
        this.dirty = true;
        if (ManagedEntity.class.isInstance(entity)) {
            managedEntity = (ManagedEntity)entity;
            alreadyAssociated = managedEntity.$$_hibernate_getEntityEntry() != null;
        } else {
            ManagedEntity wrapper = null;
            if (this.nonEnhancedEntityXref == null) {
                this.nonEnhancedEntityXref = new IdentityHashMap();
            } else {
                wrapper = this.nonEnhancedEntityXref.get(entity);
            }
            if (wrapper == null) {
                wrapper = new ManagedEntityImpl(entity);
                this.nonEnhancedEntityXref.put(entity, wrapper);
                alreadyAssociated = false;
            } else {
                alreadyAssociated = true;
            }
            managedEntity = wrapper;
        }
        managedEntity.$$_hibernate_setEntityEntry(entityEntry);
        if (alreadyAssociated) {
            return;
        }
        if (this.tail == null) {
            assert (this.head == null);
            this.tail = this.head = managedEntity;
            this.count = 1;
        } else {
            this.tail.$$_hibernate_setNextManagedEntity(managedEntity);
            managedEntity.$$_hibernate_setPreviousManagedEntity(this.tail);
            this.tail = managedEntity;
            ++this.count;
        }
    }

    public boolean hasEntityEntry(Object entity) {
        return this.getEntityEntry(entity) != null;
    }

    public EntityEntry getEntityEntry(Object entity) {
        Object managedEntity = ManagedEntity.class.isInstance(entity) ? (ManagedEntity)entity : (this.nonEnhancedEntityXref == null ? null : this.nonEnhancedEntityXref.get(entity));
        return managedEntity == null ? null : managedEntity.$$_hibernate_getEntityEntry();
    }

    public EntityEntry removeEntityEntry(Object entity) {
        this.dirty = true;
        Object managedEntity = ManagedEntity.class.isInstance(entity) ? (ManagedEntity)entity : (this.nonEnhancedEntityXref == null ? null : this.nonEnhancedEntityXref.remove(entity));
        if (managedEntity == null) {
            return null;
        }
        ManagedEntity previous = managedEntity.$$_hibernate_getPreviousManagedEntity();
        ManagedEntity next = managedEntity.$$_hibernate_getNextManagedEntity();
        managedEntity.$$_hibernate_setPreviousManagedEntity(null);
        managedEntity.$$_hibernate_setNextManagedEntity(null);
        --this.count;
        if (this.count == 0) {
            this.head = null;
            this.tail = null;
            assert (previous == null);
            assert (next == null);
        } else {
            if (previous == null) {
                assert (managedEntity == this.head);
                this.head = next;
            } else {
                previous.$$_hibernate_setNextManagedEntity(next);
            }
            if (next == null) {
                assert (managedEntity == this.tail);
                this.tail = previous;
            } else {
                next.$$_hibernate_setPreviousManagedEntity(previous);
            }
        }
        EntityEntry theEntityEntry = managedEntity.$$_hibernate_getEntityEntry();
        managedEntity.$$_hibernate_setEntityEntry(null);
        return theEntityEntry;
    }

    public Map.Entry<Object, EntityEntry>[] reentrantSafeEntityEntries() {
        if (this.dirty) {
            this.reentrantSafeEntries = new EntityEntryCrossRefImpl[this.count];
            int i = 0;
            for (ManagedEntity managedEntity = this.head; managedEntity != null; managedEntity = managedEntity.$$_hibernate_getNextManagedEntity()) {
                this.reentrantSafeEntries[i++] = new EntityEntryCrossRefImpl(managedEntity.$$_hibernate_getEntityInstance(), managedEntity.$$_hibernate_getEntityEntry());
            }
            this.dirty = false;
        }
        return this.reentrantSafeEntries;
    }

    public void clear() {
        this.dirty = true;
        ManagedEntity node = this.head;
        while (node != null) {
            ManagedEntity nextNode = node.$$_hibernate_getNextManagedEntity();
            node.$$_hibernate_setEntityEntry(null);
            node.$$_hibernate_setPreviousManagedEntity(null);
            node.$$_hibernate_setNextManagedEntity(null);
            node = nextNode;
        }
        if (this.nonEnhancedEntityXref != null) {
            this.nonEnhancedEntityXref.clear();
        }
        this.head = null;
        this.tail = null;
        this.count = 0;
        this.reentrantSafeEntries = null;
    }

    public void downgradeLocks() {
        if (this.head == null) {
            return;
        }
        for (ManagedEntity node = this.head; node != null; node = node.$$_hibernate_getNextManagedEntity()) {
            node.$$_hibernate_getEntityEntry().setLockMode(LockMode.NONE);
        }
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        log.tracef("Starting serialization of [%s] EntityEntry entries", this.count);
        oos.writeInt(this.count);
        if (this.count == 0) {
            return;
        }
        for (ManagedEntity managedEntity = this.head; managedEntity != null; managedEntity = managedEntity.$$_hibernate_getNextManagedEntity()) {
            oos.writeBoolean(managedEntity == managedEntity.$$_hibernate_getEntityInstance());
            oos.writeObject(managedEntity.$$_hibernate_getEntityInstance());
            managedEntity.$$_hibernate_getEntityEntry().serialize(oos);
        }
    }

    public static EntityEntryContext deserialize(ObjectInputStream ois, StatefulPersistenceContext rtn) throws IOException, ClassNotFoundException {
        int count = ois.readInt();
        log.tracef("Starting deserialization of [%s] EntityEntry entries", count);
        EntityEntryContext context = new EntityEntryContext();
        context.count = count;
        context.dirty = true;
        if (count == 0) {
            return context;
        }
        ManagedEntity previous = null;
        for (int i = 0; i < count; ++i) {
            ManagedEntity managedEntity;
            boolean isEnhanced = ois.readBoolean();
            Object entity = ois.readObject();
            EntityEntry entry = EntityEntry.deserialize(ois, rtn);
            if (isEnhanced) {
                managedEntity = (ManagedEntity)entity;
            } else {
                managedEntity = new ManagedEntityImpl(entity);
                if (context.nonEnhancedEntityXref == null) {
                    context.nonEnhancedEntityXref = new IdentityHashMap();
                }
                context.nonEnhancedEntityXref.put(entity, managedEntity);
            }
            managedEntity.$$_hibernate_setEntityEntry(entry);
            if (previous == null) {
                context.head = managedEntity;
            } else {
                previous.$$_hibernate_setNextManagedEntity(managedEntity);
                managedEntity.$$_hibernate_setPreviousManagedEntity(previous);
            }
            previous = managedEntity;
        }
        context.tail = previous;
        return context;
    }

    public int getNumberOfManagedEntities() {
        return this.count;
    }

    private static class EntityEntryCrossRefImpl
    implements EntityEntryCrossRef {
        private final Object entity;
        private EntityEntry entityEntry;

        private EntityEntryCrossRefImpl(Object entity, EntityEntry entityEntry) {
            this.entity = entity;
            this.entityEntry = entityEntry;
        }

        @Override
        public Object getEntity() {
            return this.entity;
        }

        @Override
        public EntityEntry getEntityEntry() {
            return this.entityEntry;
        }

        @Override
        public Object getKey() {
            return this.getEntity();
        }

        @Override
        public EntityEntry getValue() {
            return this.getEntityEntry();
        }

        @Override
        public EntityEntry setValue(EntityEntry entityEntry) {
            EntityEntry old = this.entityEntry;
            this.entityEntry = entityEntry;
            return old;
        }
    }

    public static interface EntityEntryCrossRef
    extends Map.Entry<Object, EntityEntry> {
        public Object getEntity();

        public EntityEntry getEntityEntry();
    }

    private static class ManagedEntityImpl
    implements ManagedEntity {
        private final Object entityInstance;
        private EntityEntry entityEntry;
        private ManagedEntity previous;
        private ManagedEntity next;

        public ManagedEntityImpl(Object entityInstance) {
            this.entityInstance = entityInstance;
        }

        @Override
        public Object $$_hibernate_getEntityInstance() {
            return this.entityInstance;
        }

        @Override
        public EntityEntry $$_hibernate_getEntityEntry() {
            return this.entityEntry;
        }

        @Override
        public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
            this.entityEntry = entityEntry;
        }

        @Override
        public ManagedEntity $$_hibernate_getNextManagedEntity() {
            return this.next;
        }

        @Override
        public void $$_hibernate_setNextManagedEntity(ManagedEntity next) {
            this.next = next;
        }

        @Override
        public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
            return this.previous;
        }

        @Override
        public void $$_hibernate_setPreviousManagedEntity(ManagedEntity previous) {
            this.previous = previous;
        }
    }
}

