/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;

public class FirstLimitHandler
extends AbstractLimitHandler {
    public static final FirstLimitHandler INSTANCE = new FirstLimitHandler();

    private FirstLimitHandler() {
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        boolean hasOffset = LimitHelper.hasFirstRow(selection);
        if (hasOffset) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuilder(sql.length() + 16).append(sql).insert(sql.toLowerCase().indexOf("select") + 6, " first ?").toString();
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }
}

