/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.spi.ConstraintSource;
import org.hibernate.boot.model.source.spi.IndexConstraintSource;
import org.hibernate.boot.model.source.spi.UniqueKeyConstraintSource;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class ConstraintSecondPass
implements SecondPass {
    private final MappingDocument sourceDocument;
    private final Table table;
    private final ConstraintSource constraintSource;

    public ConstraintSecondPass(MappingDocument sourceDocument, Table table, ConstraintSource constraintSource) {
        this.sourceDocument = sourceDocument;
        this.table = table;
        this.constraintSource = constraintSource;
    }

    @Override
    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (IndexConstraintSource.class.isInstance(this.constraintSource)) {
            this.bindIndexConstraint();
        } else if (UniqueKeyConstraintSource.class.isInstance(this.constraintSource)) {
            this.bindUniqueKeyConstraint();
        }
    }

    private void bindIndexConstraint() {
        Index index = this.table.getOrCreateIndex(this.constraintSource.name());
        for (String columnName : this.constraintSource.columnNames()) {
            Identifier physicalName = this.sourceDocument.getMetadataCollector().getDatabase().toIdentifier(this.sourceDocument.getMetadataCollector().getPhysicalColumnName(this.table, columnName));
            index.addColumn(this.table.getColumn(physicalName));
        }
    }

    private void bindUniqueKeyConstraint() {
        UniqueKey index = this.table.getOrCreateUniqueKey(this.constraintSource.name());
        for (String columnName : this.constraintSource.columnNames()) {
            Identifier physicalName = this.sourceDocument.getMetadataCollector().getDatabase().toIdentifier(this.sourceDocument.getMetadataCollector().getPhysicalColumnName(this.table, columnName));
            index.addColumn(this.table.getColumn(physicalName));
        }
    }
}

