/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.DefaultCustomEntityDirtinessStrategy;
import org.hibernate.boot.internal.StandardEntityNotFoundDelegate;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.EntityTuplizerFactory;

public class SessionFactoryBuilderImpl
implements SessionFactoryBuilder {
    private final MetadataImplementor metadata;
    private final SessionFactoryOptionsImpl options;

    SessionFactoryBuilderImpl(MetadataImplementor metadata) {
        this.metadata = metadata;
        this.options = new SessionFactoryOptionsImpl(metadata.getMetadataBuildingOptions().getServiceRegistry());
        if (metadata.getSqlFunctionMap() != null) {
            for (Map.Entry<String, SQLFunction> sqlFunctionEntry : metadata.getSqlFunctionMap().entrySet()) {
                this.applySqlFunction(sqlFunctionEntry.getKey(), sqlFunctionEntry.getValue());
            }
        }
    }

    @Override
    public SessionFactoryBuilder applyInterceptor(Interceptor interceptor) {
        this.options.interceptor = interceptor;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyCustomEntityDirtinessStrategy(CustomEntityDirtinessStrategy strategy) {
        this.options.customEntityDirtinessStrategy = strategy;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver resolver) {
        this.options.currentTenantIdentifierResolver = resolver;
        return this;
    }

    @Override
    public SessionFactoryBuilder addSessionFactoryObservers(SessionFactoryObserver ... observers) {
        this.options.sessionFactoryObserverList.addAll(Arrays.asList(observers));
        return this;
    }

    @Override
    public SessionFactoryBuilder addEntityNameResolver(EntityNameResolver ... entityNameResolvers) {
        this.options.entityNameResolvers.addAll(Arrays.asList(entityNameResolvers));
        return this;
    }

    @Override
    public SessionFactoryBuilder applyEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.options.entityNotFoundDelegate = entityNotFoundDelegate;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyEntityTuplizerFactory(EntityTuplizerFactory entityTuplizerFactory) {
        this.options.settings.setEntityTuplizerFactory(entityTuplizerFactory);
        return this;
    }

    @Override
    public SessionFactoryBuilder applyEntityTuplizer(EntityMode entityMode, Class<? extends EntityTuplizer> tuplizerClass) {
        if (this.options.settings.getEntityTuplizerFactory() == null) {
            this.options.settings.setEntityTuplizerFactory(new EntityTuplizerFactory());
        }
        this.options.settings.getEntityTuplizerFactory().registerDefaultTuplizerClass(entityMode, tuplizerClass);
        return this;
    }

    @Override
    public SessionFactoryBuilder applyValidatorFactory(Object validatorFactory) {
        this.options.validatorFactoryReference = validatorFactory;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyBeanManager(Object beanManager) {
        this.options.beanManagerReference = beanManager;
        return this;
    }

    @Override
    public SessionFactoryBuilder applySqlFunction(String registrationName, SQLFunction sqlFunction) {
        if (this.options.sqlFunctions == null) {
            this.options.sqlFunctions = new HashMap();
        }
        this.options.sqlFunctions.put(registrationName, sqlFunction);
        return this;
    }

    @Override
    public SessionFactory build() {
        this.metadata.validate();
        return new SessionFactoryImpl(this.metadata, this.options);
    }

    private static class SessionFactoryOptionsImpl
    implements SessionFactory.SessionFactoryOptions {
        private final StandardServiceRegistry serviceRegistry;
        private Interceptor interceptor;
        private CustomEntityDirtinessStrategy customEntityDirtinessStrategy;
        private CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
        private List<SessionFactoryObserver> sessionFactoryObserverList = new ArrayList<SessionFactoryObserver>();
        private List<EntityNameResolver> entityNameResolvers = new ArrayList<EntityNameResolver>();
        private EntityNotFoundDelegate entityNotFoundDelegate;
        private Settings settings;
        private Object beanManagerReference;
        private Object validatorFactoryReference;
        private Map<String, SQLFunction> sqlFunctions;

        public SessionFactoryOptionsImpl(StandardServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            Map configurationSettings = serviceRegistry.getService(ConfigurationService.class).getSettings();
            StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
            this.interceptor = strategySelector.resolveDefaultableStrategy(Interceptor.class, configurationSettings.get("hibernate.session_factory.interceptor"), EmptyInterceptor.INSTANCE);
            this.entityNotFoundDelegate = StandardEntityNotFoundDelegate.INSTANCE;
            this.customEntityDirtinessStrategy = strategySelector.resolveDefaultableStrategy(CustomEntityDirtinessStrategy.class, configurationSettings.get("hibernate.entity_dirtiness_strategy"), DefaultCustomEntityDirtinessStrategy.INSTANCE);
            this.currentTenantIdentifierResolver = strategySelector.resolveStrategy(CurrentTenantIdentifierResolver.class, configurationSettings.get("hibernate.tenant_identifier_resolver"));
            this.beanManagerReference = configurationSettings.get("javax.persistence.bean.manager");
            this.validatorFactoryReference = configurationSettings.get("javax.persistence.validation.factory");
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)configurationSettings);
            this.settings = new SettingsFactory().buildSettings(properties, serviceRegistry);
            this.settings.setEntityTuplizerFactory(new EntityTuplizerFactory());
        }

        @Override
        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public Interceptor getInterceptor() {
            return this.interceptor;
        }

        @Override
        public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
            return this.customEntityDirtinessStrategy;
        }

        @Override
        public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
            return this.currentTenantIdentifierResolver;
        }

        @Override
        public Settings getSettings() {
            return this.settings;
        }

        @Override
        public SessionFactoryObserver[] getSessionFactoryObservers() {
            return this.sessionFactoryObserverList.toArray(new SessionFactoryObserver[this.sessionFactoryObserverList.size()]);
        }

        @Override
        public EntityNameResolver[] getEntityNameResolvers() {
            return this.entityNameResolvers.toArray(new EntityNameResolver[this.entityNameResolvers.size()]);
        }

        @Override
        public EntityNotFoundDelegate getEntityNotFoundDelegate() {
            return this.entityNotFoundDelegate;
        }

        @Override
        public Map<String, SQLFunction> getCustomSqlFunctionMap() {
            return this.sqlFunctions;
        }

        @Override
        public Object getBeanManagerReference() {
            return this.beanManagerReference;
        }

        @Override
        public Object getValidatorFactoryReference() {
            return this.validatorFactoryReference;
        }
    }
}

