/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Converter;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.archive.internal.StandardArchiveDescriptorFactory;
import org.hibernate.boot.archive.scan.internal.StandardScanner;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.JandexInitializer;
import org.hibernate.boot.archive.scan.spi.MappingFileDescriptor;
import org.hibernate.boot.archive.scan.spi.PackageDescriptor;
import org.hibernate.boot.archive.scan.spi.ScanParameters;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.internal.DeploymentResourcesInterpreter;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.source.internal.annotations.AnnotationMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchyBuilder;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.HbmMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.internal.hbm.ModelBinder;
import org.hibernate.boot.model.source.spi.MetadataSourceProcessor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.cfg.AttributeConverterDefinition;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class MetadataBuildingProcess {
    private static final Logger log = Logger.getLogger(MetadataBuildingProcess.class);
    private static final Class[] SINGLE_ARG = new Class[]{ArchiveDescriptorFactory.class};

    public static MetadataImpl build(final MetadataSources sources, final MetadataBuilderImpl.MetadataBuildingOptionsImpl options) {
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        ClassLoaderAccessImpl classLoaderAccess = new ClassLoaderAccessImpl(options.getTempClassLoader(), classLoaderService);
        if (options.getScanEnvironment() != null) {
            Scanner scanner = MetadataBuildingProcess.buildScanner(options, classLoaderAccess);
            ScanResult scanResult = scanner.scan(options.getScanEnvironment(), options.getScanOptions(), new ScanParameters(){

                @Override
                public JandexInitializer getJandexInitializer() {
                    return null;
                }
            });
            MetadataBuildingProcess.addScanResultsToSources(sources, options, scanResult);
        }
        final IndexView jandexView = options.getJandexView();
        BasicTypeRegistry basicTypeRegistry = MetadataBuildingProcess.handleTypes(options);
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl(options, sources, new TypeResolver(basicTypeRegistry, new TypeFactory()));
        final MetadataBuildingContextRootImpl rootMetadataBuildingContext = new MetadataBuildingContextRootImpl(options, classLoaderAccess, metadataCollector);
        MetadataSourceProcessor processor = new MetadataSourceProcessor(){
            private final HbmMetadataSourceProcessorImpl hbmProcessor;
            private final AnnotationMetadataSourceProcessorImpl annotationProcessor;
            {
                this.hbmProcessor = new HbmMetadataSourceProcessorImpl(sources, (MetadataBuildingContext)rootMetadataBuildingContext);
                this.annotationProcessor = new AnnotationMetadataSourceProcessorImpl(sources, rootMetadataBuildingContext, jandexView);
            }

            @Override
            public void prepare() {
                this.hbmProcessor.prepare();
                this.annotationProcessor.prepare();
            }

            @Override
            public void processTypeDefinitions() {
                this.hbmProcessor.processTypeDefinitions();
                this.annotationProcessor.processTypeDefinitions();
            }

            @Override
            public void processQueryRenames() {
                this.hbmProcessor.processQueryRenames();
                this.annotationProcessor.processQueryRenames();
            }

            @Override
            public void processNamedQueries() {
                this.hbmProcessor.processNamedQueries();
                this.annotationProcessor.processNamedQueries();
            }

            @Override
            public void processAuxiliaryDatabaseObjectDefinitions() {
                this.hbmProcessor.processAuxiliaryDatabaseObjectDefinitions();
                this.annotationProcessor.processAuxiliaryDatabaseObjectDefinitions();
            }

            @Override
            public void processIdentifierGenerators() {
                this.hbmProcessor.processIdentifierGenerators();
                this.annotationProcessor.processIdentifierGenerators();
            }

            @Override
            public void processFilterDefinitions() {
                this.hbmProcessor.processFilterDefinitions();
                this.annotationProcessor.processFilterDefinitions();
            }

            @Override
            public void processFetchProfiles() {
                this.hbmProcessor.processFetchProfiles();
                this.annotationProcessor.processFetchProfiles();
            }

            @Override
            public void prepareForEntityHierarchyProcessing() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.prepareForEntityHierarchyProcessing();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.prepareForEntityHierarchyProcessing();
                }
            }

            @Override
            public void processEntityHierarchies(Set<String> processedEntityNames) {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.processEntityHierarchies(processedEntityNames);
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.processEntityHierarchies(processedEntityNames);
                }
            }

            @Override
            public void postProcessEntityHierarchies() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.postProcessEntityHierarchies();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.postProcessEntityHierarchies();
                }
            }

            @Override
            public void processResultSetMappings() {
                this.hbmProcessor.processResultSetMappings();
                this.annotationProcessor.processResultSetMappings();
            }

            @Override
            public void finishUp() {
                this.hbmProcessor.finishUp();
                this.annotationProcessor.finishUp();
            }
        };
        processor.prepare();
        processor.processTypeDefinitions();
        processor.processQueryRenames();
        processor.processAuxiliaryDatabaseObjectDefinitions();
        processor.processIdentifierGenerators();
        processor.processFilterDefinitions();
        processor.processFetchProfiles();
        HashSet<String> processedEntityNames = new HashSet<String>();
        processor.prepareForEntityHierarchyProcessing();
        processor.processEntityHierarchies(processedEntityNames);
        processor.postProcessEntityHierarchies();
        processor.processResultSetMappings();
        processor.processNamedQueries();
        processor.finishUp();
        for (MetadataContributor contributor : classLoaderService.loadJavaServices(MetadataContributor.class)) {
            log.tracef("Calling MetadataContributor : %s", (Object)contributor);
            contributor.contribute(metadataCollector, jandexView);
        }
        metadataCollector.processSecondPasses(rootMetadataBuildingContext);
        LinkedHashSet<AdditionalJaxbMappingProducer> producers = classLoaderService.loadJavaServices(AdditionalJaxbMappingProducer.class);
        if (producers != null && !producers.isEmpty()) {
            EntityHierarchyBuilder hierarchyBuilder = new EntityHierarchyBuilder();
            MappingBinder mappingBinder = new MappingBinder(false);
            for (AdditionalJaxbMappingProducer producer : producers) {
                log.tracef("Calling AdditionalJaxbMappingProducer : %s", (Object)producer);
                Collection<MappingDocument> additionalMappings = producer.produceAdditionalMappings(metadataCollector, jandexView, mappingBinder, rootMetadataBuildingContext);
                for (MappingDocument mappingDocument : additionalMappings) {
                    hierarchyBuilder.indexMappingDocument(mappingDocument);
                }
            }
            ModelBinder binder = ModelBinder.prepare(rootMetadataBuildingContext);
            for (EntityHierarchySourceImpl entityHierarchySource : hierarchyBuilder.buildHierarchies()) {
                binder.bindEntityHierarchy(entityHierarchySource);
            }
        }
        return metadataCollector.buildMetadataInstance(rootMetadataBuildingContext);
    }

    private static Scanner buildScanner(MetadataBuildingOptions options, ClassLoaderAccess classLoaderAccess) {
        Object scannerSetting = options.getScanner();
        ArchiveDescriptorFactory archiveDescriptorFactory = options.getArchiveDescriptorFactory();
        if (scannerSetting == null) {
            if (archiveDescriptorFactory == null) {
                return new StandardScanner();
            }
            return new StandardScanner(archiveDescriptorFactory);
        }
        if (Scanner.class.isInstance(scannerSetting)) {
            if (archiveDescriptorFactory != null) {
                throw new IllegalStateException("A Scanner instance and an ArchiveDescriptorFactory were both specified; please specify one or the other, or if you need to supply both, Scanner class to use (assuming it has a constructor accepting a ArchiveDescriptorFactory).  Alternatively, just pass the ArchiveDescriptorFactory during your own Scanner constructor assuming it is statically known.");
            }
            return (Scanner)scannerSetting;
        }
        Class scannerImplClass = Class.class.isInstance(scannerSetting) ? (Class)scannerSetting : classLoaderAccess.classForName(scannerSetting.toString());
        if (archiveDescriptorFactory != null) {
            try {
                Constructor constructor = scannerImplClass.getConstructor(SINGLE_ARG);
                try {
                    return (Scanner)constructor.newInstance(archiveDescriptorFactory);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error trying to instantiate custom specified Scanner [" + scannerImplClass.getName() + "]", e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Configuration named a custom Scanner and a custom ArchiveDescriptorFactory, but Scanner impl did not define a constructor accepting ArchiveDescriptorFactory");
            }
        }
        try {
            Constructor constructor = scannerImplClass.getConstructor(SINGLE_ARG);
            try {
                return (Scanner)constructor.newInstance(StandardArchiveDescriptorFactory.INSTANCE);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error trying to instantiate custom specified Scanner [" + scannerImplClass.getName() + "]", e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor constructor = scannerImplClass.getConstructor(new Class[0]);
                try {
                    return (Scanner)constructor.newInstance(new Object[0]);
                }
                catch (Exception e2) {
                    throw new IllegalStateException("Error trying to instantiate custom specified Scanner [" + scannerImplClass.getName() + "]", e2);
                }
            }
            catch (NoSuchMethodException ignore) {
                throw new IllegalArgumentException("Configuration named a custom Scanner, but we were unable to locate an appropriate constructor");
            }
        }
    }

    private static void addScanResultsToSources(MetadataSources sources, MetadataBuilderImpl.MetadataBuildingOptionsImpl options, ScanResult scanResult) {
        ClassLoaderService cls = options.getServiceRegistry().getService(ClassLoaderService.class);
        DeploymentResourcesInterpreter.DeploymentResources deploymentResources = DeploymentResourcesInterpreter.INSTANCE.buildDeploymentResources(options.getScanEnvironment(), scanResult, options.getServiceRegistry());
        for (ClassDescriptor classDescriptor : deploymentResources.getClassDescriptors()) {
            String className = classDescriptor.getName();
            try {
                Class classRef = cls.classForName(className);
                Converter converter = classRef.getAnnotation(Converter.class);
                if (converter != null) {
                    options.addAttributeConverterDefinition(AttributeConverterDefinition.from(classRef, converter.autoApply()));
                    continue;
                }
                sources.addAnnotatedClass(classRef);
            }
            catch (ClassLoadingException e) {
                sources.addAnnotatedClassName(className);
            }
        }
        for (PackageDescriptor packageDescriptor : deploymentResources.getPackageDescriptors()) {
            sources.addPackage(packageDescriptor.getName());
        }
        for (MappingFileDescriptor mappingFileDescriptor : deploymentResources.getMappingFileDescriptors()) {
            sources.addInputStream(mappingFileDescriptor.getStreamAccess());
        }
    }

    private static BasicTypeRegistry handleTypes(MetadataBuildingOptions options) {
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        final BasicTypeRegistry basicTypeRegistry = new BasicTypeRegistry();
        TypeContributions typeContributions = new TypeContributions(){

            @Override
            public void contributeType(BasicType type) {
                basicTypeRegistry.register(type);
            }

            @Override
            public void contributeType(UserType type, String[] keys) {
                basicTypeRegistry.register(type, keys);
            }

            @Override
            public void contributeType(CompositeUserType type, String[] keys) {
                basicTypeRegistry.register(type, keys);
            }
        };
        Dialect dialect = options.getServiceRegistry().getService(JdbcServices.class).getDialect();
        dialect.contributeTypes(typeContributions, options.getServiceRegistry());
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, options.getServiceRegistry());
        }
        for (BasicType basicType : options.getBasicTypeRegistrations()) {
            basicTypeRegistry.register(basicType);
        }
        return basicTypeRegistry;
    }
}

