/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.archive.internal.UrlInputStreamAccess;
import org.hibernate.boot.archive.scan.internal.ClassDescriptorImpl;
import org.hibernate.boot.archive.scan.internal.MappingFileDescriptorImpl;
import org.hibernate.boot.archive.scan.internal.PackageDescriptorImpl;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.MappingFileDescriptor;
import org.hibernate.boot.archive.scan.spi.PackageDescriptor;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

public class DeploymentResourcesInterpreter {
    public static final DeploymentResourcesInterpreter INSTANCE = new DeploymentResourcesInterpreter();
    private static final Logger log = Logger.getLogger(DeploymentResourcesInterpreter.class);

    public DeploymentResources buildDeploymentResources(ScanEnvironment scanEnvironment, ScanResult scanResult, ServiceRegistry serviceRegistry) {
        final ArrayList<MappingFileDescriptor> mappingFileDescriptors = new ArrayList<MappingFileDescriptor>();
        HashSet<String> nonLocatedMappingFileNames = new HashSet<String>();
        List<String> explicitMappingFileNames = scanEnvironment.getExplicitlyListedMappingFiles();
        if (explicitMappingFileNames != null) {
            nonLocatedMappingFileNames.addAll(explicitMappingFileNames);
        }
        for (MappingFileDescriptor mappingFileDescriptor : scanResult.getLocatedMappingFiles()) {
            mappingFileDescriptors.add(mappingFileDescriptor);
            nonLocatedMappingFileNames.remove(mappingFileDescriptor.getName());
        }
        for (String name : nonLocatedMappingFileNames) {
            Iterator<PackageDescriptor> descriptor = this.buildMappingFileDescriptor(name, serviceRegistry);
            mappingFileDescriptors.add((MappingFileDescriptor)((Object)descriptor));
        }
        final HashMap<String, ClassDescriptor> classDescriptorMap = new HashMap<String, ClassDescriptor>();
        final HashMap<String, PackageDescriptor> packageDescriptorMap = new HashMap<String, PackageDescriptor>();
        for (ClassDescriptor classDescriptor : scanResult.getLocatedClasses()) {
            classDescriptorMap.put(classDescriptor.getName(), classDescriptor);
        }
        for (PackageDescriptor packageDescriptor : scanResult.getLocatedPackages()) {
            packageDescriptorMap.put(packageDescriptor.getName(), packageDescriptor);
        }
        List<String> explicitClassNames = scanEnvironment.getExplicitlyListedClassNames();
        if (explicitClassNames != null) {
            for (String explicitClassName : explicitClassNames) {
                if (classDescriptorMap.containsKey(explicitClassName) || packageDescriptorMap.containsKey(explicitClassName)) continue;
                String classFileName = explicitClassName.replace('.', '/') + ".class";
                URL classFileUrl = serviceRegistry.getService(ClassLoaderService.class).locateResource(classFileName);
                if (classFileUrl != null) {
                    classDescriptorMap.put(explicitClassName, new ClassDescriptorImpl(explicitClassName, new UrlInputStreamAccess(classFileUrl)));
                    continue;
                }
                String packageInfoFileName = explicitClassName.replace('.', '/') + "/package-info.class";
                URL packageInfoFileUrl = serviceRegistry.getService(ClassLoaderService.class).locateResource(packageInfoFileName);
                if (packageInfoFileUrl != null) {
                    packageDescriptorMap.put(explicitClassName, new PackageDescriptorImpl(explicitClassName, new UrlInputStreamAccess(packageInfoFileUrl)));
                    continue;
                }
                log.debugf("Unable to resolve class [%s] named in persistence unit [%s]", (Object)explicitClassName, (Object)scanEnvironment.getRootUrl().toExternalForm());
            }
        }
        return new DeploymentResources(){

            @Override
            public Iterable<ClassDescriptor> getClassDescriptors() {
                return classDescriptorMap.values();
            }

            @Override
            public Iterable<PackageDescriptor> getPackageDescriptors() {
                return packageDescriptorMap.values();
            }

            @Override
            public Iterable<MappingFileDescriptor> getMappingFileDescriptors() {
                return mappingFileDescriptors;
            }
        };
    }

    private MappingFileDescriptor buildMappingFileDescriptor(String name, ServiceRegistry serviceRegistry) {
        URL url = serviceRegistry.getService(ClassLoaderService.class).locateResource(name);
        if (url == null) {
            throw new MappingException("Unable to resolve explicitly named mapping-file : " + name, new Origin(SourceType.RESOURCE, name));
        }
        return new MappingFileDescriptorImpl(name, new UrlInputStreamAccess(url));
    }

    public static interface DeploymentResources {
        public Iterable<ClassDescriptor> getClassDescriptors();

        public Iterable<PackageDescriptor> getPackageDescriptors();

        public Iterable<MappingFileDescriptor> getMappingFileDescriptors();
    }
}

