/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.archive.scan.spi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.persistence.Converter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.boot.archive.scan.internal.ClassDescriptorImpl;
import org.hibernate.boot.archive.scan.internal.ScanResultCollector;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.spi.ArchiveContext;
import org.hibernate.boot.archive.spi.ArchiveEntry;
import org.hibernate.boot.archive.spi.ArchiveEntryHandler;
import org.hibernate.boot.archive.spi.ArchiveException;

public class ClassFileArchiveEntryHandler
implements ArchiveEntryHandler {
    private final ScanResultCollector resultCollector;

    public ClassFileArchiveEntryHandler(ScanResultCollector resultCollector) {
        this.resultCollector = resultCollector;
    }

    @Override
    public void handleEntry(ArchiveEntry entry, ArchiveContext context) {
        ClassFile classFile = this.toClassFile(entry);
        ClassDescriptor classDescriptor = this.toClassDescriptor(classFile, entry);
        if (!this.containsClassAnnotationsOfInterest(classFile)) {
            return;
        }
        this.resultCollector.handleClass(this.toClassDescriptor(this.toClassFile(entry), entry), context.isRootUrl());
    }

    private ClassFile toClassFile(ArchiveEntry entry) {
        InputStream inputStream = entry.getStreamAccess().accessInputStream();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            ClassFile classFile = new ClassFile(dataInputStream);
            return classFile;
        }
        catch (IOException e) {
            throw new ArchiveException("Could not build ClassFile");
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean containsClassAnnotationsOfInterest(ClassFile cf) {
        AnnotationsAttribute visibleAnnotations = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visibleAnnotations == null) {
            return false;
        }
        return visibleAnnotations.getAnnotation(Entity.class.getName()) != null || visibleAnnotations.getAnnotation(MappedSuperclass.class.getName()) != null || visibleAnnotations.getAnnotation(Embeddable.class.getName()) != null || visibleAnnotations.getAnnotation(Converter.class.getName()) != null;
    }

    private ClassDescriptor toClassDescriptor(ClassFile classFile, ArchiveEntry entry) {
        return new ClassDescriptorImpl(classFile.getName(), entry.getStreamAccess());
    }
}

