/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.transform.dom.DOMSource;
import org.hibernate.boot.MappingNotFoundException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.archive.spi.InputStreamAccess;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.internal.CacheableFileXmlSource;
import org.hibernate.boot.jaxb.internal.FileXmlSource;
import org.hibernate.boot.jaxb.internal.InputStreamXmlSource;
import org.hibernate.boot.jaxb.internal.JarFileEntryXmlSource;
import org.hibernate.boot.jaxb.internal.JaxpSourceXmlSource;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.internal.UrlXmlSource;
import org.hibernate.boot.jaxb.spi.Binder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.SerializationException;
import org.w3c.dom.Document;

public class MetadataSources
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(MetadataSources.class);
    private final ServiceRegistry serviceRegistry;
    private Binder mappingsBinder = new MappingBinder(true);
    private List<Binding> xmlBindings = new ArrayList<Binding>();
    private LinkedHashSet<Class<?>> annotatedClasses = new LinkedHashSet();
    private LinkedHashSet<String> annotatedClassNames = new LinkedHashSet();
    private LinkedHashSet<String> annotatedPackages = new LinkedHashSet();

    public MetadataSources() {
        this(new BootstrapServiceRegistryBuilder().build());
    }

    public MetadataSources(ServiceRegistry serviceRegistry) {
        if (!MetadataSources.isExpectedServiceRegistryType(serviceRegistry)) {
            LOG.debugf("Unexpected ServiceRegistry type [%s] encountered during building of MetadataSources; may cause problems later attempting to construct MetadataBuilder", serviceRegistry.getClass().getName());
        }
        this.serviceRegistry = serviceRegistry;
    }

    protected static boolean isExpectedServiceRegistryType(ServiceRegistry serviceRegistry) {
        return BootstrapServiceRegistry.class.isInstance(serviceRegistry) || StandardServiceRegistry.class.isInstance(serviceRegistry);
    }

    public List<Binding> getXmlBindings() {
        return this.xmlBindings;
    }

    public Collection<String> getAnnotatedPackages() {
        return this.annotatedPackages;
    }

    public Collection<Class<?>> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public Collection<String> getAnnotatedClassNames() {
        return this.annotatedClassNames;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public MetadataBuilder getMetadataBuilder() {
        return new MetadataBuilderImpl(this);
    }

    public MetadataBuilder getMetadataBuilder(StandardServiceRegistry serviceRegistry) {
        return new MetadataBuilderImpl(this, serviceRegistry);
    }

    public Metadata buildMetadata() {
        return this.getMetadataBuilder().build();
    }

    public Metadata buildMetadata(StandardServiceRegistry serviceRegistry) {
        return this.getMetadataBuilder(serviceRegistry).build();
    }

    public MetadataSources addAnnotatedClass(Class annotatedClass) {
        this.annotatedClasses.add(annotatedClass);
        return this;
    }

    public MetadataSources addAnnotatedClassName(String annotatedClassName) {
        this.annotatedClassNames.add(annotatedClassName);
        return this;
    }

    public MetadataSources addPackage(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("The specified package name cannot be null");
        }
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        this.annotatedPackages.add(packageName);
        return this;
    }

    public MetadataSources addResource(String name) {
        LOG.tracef("reading mappings from resource : %s", name);
        Origin origin = new Origin(SourceType.RESOURCE, name);
        URL url = this.classLoaderService().locateResource(name);
        if (url == null) {
            throw new MappingNotFoundException(origin);
        }
        this.xmlBindings.add(new UrlXmlSource(origin, url).doBind(this.mappingsBinder));
        return this;
    }

    private ClassLoaderService classLoaderService() {
        return this.serviceRegistry.getService(ClassLoaderService.class);
    }

    @Deprecated
    public MetadataSources addClass(Class entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("The specified class cannot be null");
        }
        LOG.debugf("adding resource mappings from class convention : %s", entityClass.getName());
        String mappingResourceName = entityClass.getName().replace('.', '/') + ".hbm.xml";
        this.addResource(mappingResourceName);
        return this;
    }

    public MetadataSources addFile(String path) {
        this.addFile(new Origin(SourceType.FILE, path), new File(path));
        return this;
    }

    private void addFile(Origin origin, File file) {
        LOG.tracef("reading mappings from file : %s", origin.getName());
        if (!file.exists()) {
            throw new MappingNotFoundException(origin);
        }
        this.xmlBindings.add(new FileXmlSource(origin, file).doBind(this.mappingsBinder));
    }

    public MetadataSources addFile(File file) {
        this.addFile(new Origin(SourceType.FILE, file.getPath()), file);
        return this;
    }

    public MetadataSources addCacheableFile(String path) {
        Origin origin = new Origin(SourceType.FILE, path);
        this.addCacheableFile(origin, new File(path));
        return this;
    }

    private void addCacheableFile(Origin origin, File file) {
        this.xmlBindings.add(new CacheableFileXmlSource(origin, file, false).doBind(this.mappingsBinder));
    }

    public MetadataSources addCacheableFile(File file) {
        Origin origin = new Origin(SourceType.FILE, file.getName());
        this.addCacheableFile(origin, file);
        return this;
    }

    public MetadataSources addCacheableFileStrictly(File file) throws SerializationException, FileNotFoundException {
        Origin origin = new Origin(SourceType.FILE, file.getAbsolutePath());
        this.xmlBindings.add(new CacheableFileXmlSource(origin, file, true).doBind(this.mappingsBinder));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataSources addInputStream(InputStreamAccess xmlInputStreamAccess) {
        Origin origin = new Origin(SourceType.INPUT_STREAM, xmlInputStreamAccess.getStreamName());
        InputStream xmlInputStream = xmlInputStreamAccess.accessInputStream();
        try {
            this.xmlBindings.add(new InputStreamXmlSource(origin, xmlInputStream, false).doBind(this.mappingsBinder));
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException e) {
                LOG.debugf("Unable to close InputStream obtained from InputStreamAccess : " + xmlInputStreamAccess.getStreamName(), new Object[0]);
            }
        }
        return this;
    }

    public MetadataSources addInputStream(InputStream xmlInputStream) {
        Origin origin = new Origin(SourceType.INPUT_STREAM, null);
        this.xmlBindings.add(new InputStreamXmlSource(origin, xmlInputStream, false).doBind(this.mappingsBinder));
        return this;
    }

    public MetadataSources addURL(URL url) {
        String urlExternalForm = url.toExternalForm();
        LOG.debugf("Reading mapping document from URL : %s", urlExternalForm);
        Origin origin = new Origin(SourceType.URL, urlExternalForm);
        this.xmlBindings.add(new UrlXmlSource(origin, url).doBind(this.mappingsBinder));
        return this;
    }

    @Deprecated
    public MetadataSources addDocument(Document document) {
        Origin origin = new Origin(SourceType.DOM, "<unknown>");
        this.xmlBindings.add(new JaxpSourceXmlSource(origin, new DOMSource(document)).doBind(this.mappingsBinder));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataSources addJar(File jar) {
        LOG.debugf("Seeking mapping documents in jar file : %s", jar.getName());
        Origin origin = new Origin(SourceType.JAR, jar.getAbsolutePath());
        try {
            JarFile jarFile = new JarFile(jar);
            try {
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    ZipEntry zipEntry = jarEntries.nextElement();
                    if (!zipEntry.getName().endsWith(".hbm.xml")) continue;
                    LOG.tracef("found mapping document : %s", zipEntry.getName());
                    this.xmlBindings.add(new JarFileEntryXmlSource(origin, jarFile, zipEntry).doBind(this.mappingsBinder));
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            throw new MappingNotFoundException(e, origin);
        }
        return this;
    }

    public MetadataSources addDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.addDirectory(file);
                    continue;
                }
                if (!file.getName().endsWith(".hbm.xml")) continue;
                this.addFile(file);
            }
        }
        return this;
    }
}

