/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.exec.internal;

import java.util.Iterator;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.plan2.exec.internal.AliasResolutionContextImpl;
import org.hibernate.loader.plan2.exec.internal.EntityReferenceAliasesImpl;
import org.hibernate.loader.plan2.exec.internal.FetchStats;
import org.hibernate.loader.plan2.exec.process.internal.CollectionReferenceInitializerImpl;
import org.hibernate.loader.plan2.exec.process.internal.EntityReferenceInitializerImpl;
import org.hibernate.loader.plan2.exec.process.spi.ReaderCollector;
import org.hibernate.loader.plan2.exec.query.internal.SelectStatementBuilder;
import org.hibernate.loader.plan2.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan2.exec.spi.CollectionReferenceAliases;
import org.hibernate.loader.plan2.exec.spi.EntityReferenceAliases;
import org.hibernate.loader.plan2.spi.CollectionFetch;
import org.hibernate.loader.plan2.spi.CollectionQuerySpace;
import org.hibernate.loader.plan2.spi.CompositeQuerySpace;
import org.hibernate.loader.plan2.spi.EntityFetch;
import org.hibernate.loader.plan2.spi.EntityQuerySpace;
import org.hibernate.loader.plan2.spi.EntityReference;
import org.hibernate.loader.plan2.spi.Fetch;
import org.hibernate.loader.plan2.spi.FetchSource;
import org.hibernate.loader.plan2.spi.Join;
import org.hibernate.loader.plan2.spi.JoinDefinedByMetadata;
import org.hibernate.loader.plan2.spi.QuerySpace;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.walking.internal.FetchStrategyHelper;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.jboss.logging.Logger;

public class LoadQueryJoinAndFetchProcessor {
    private static final Logger LOG = CoreLogging.logger(LoadQueryJoinAndFetchProcessor.class);
    private final AliasResolutionContextImpl aliasResolutionContext;
    private final QueryBuildingParameters buildingParameters;
    private final SessionFactoryImplementor factory;

    public LoadQueryJoinAndFetchProcessor(AliasResolutionContextImpl aliasResolutionContext, QueryBuildingParameters buildingParameters, SessionFactoryImplementor factory) {
        this.aliasResolutionContext = aliasResolutionContext;
        this.buildingParameters = buildingParameters;
        this.factory = factory;
    }

    public void processQuerySpaceJoins(QuerySpace querySpace, SelectStatementBuilder selectStatementBuilder) {
        LOG.debug((Object)("processing queryspace " + querySpace.getUid()));
        JoinFragment joinFragment = this.factory.getDialect().createOuterJoinFragment();
        this.processQuerySpaceJoins(querySpace, joinFragment);
        selectStatementBuilder.setOuterJoins(joinFragment.toFromFragmentString(), joinFragment.toWhereFragmentString());
    }

    private void processQuerySpaceJoins(QuerySpace querySpace, JoinFragment joinFragment) {
        for (Join join : querySpace.getJoins()) {
            this.processQuerySpaceJoin(join, joinFragment);
        }
    }

    private void processQuerySpaceJoin(Join join, JoinFragment joinFragment) {
        this.renderJoin(join, joinFragment);
        this.processQuerySpaceJoins(join.getRightHandSide(), joinFragment);
    }

    private void renderJoin(Join join, JoinFragment joinFragment) {
        if (CompositeQuerySpace.class.isInstance(join.getRightHandSide())) {
            this.handleCompositeJoin(join, joinFragment);
        } else if (EntityQuerySpace.class.isInstance(join.getRightHandSide())) {
            if (join.getLeftHandSide().getDisposition() == QuerySpace.Disposition.COLLECTION && ((CollectionQuerySpace)CollectionQuerySpace.class.cast(join.getLeftHandSide())).getCollectionPersister().isManyToMany()) {
                CollectionQuerySpace leftHandSide = (CollectionQuerySpace)join.getLeftHandSide();
                CollectionReferenceAliases aliases = this.aliasResolutionContext.resolveCollectionReferenceAliases(leftHandSide.getUid());
                this.renderManyToManyJoin(aliases, leftHandSide, join, joinFragment);
            } else if (join.getLeftHandSide().getDisposition() != QuerySpace.Disposition.COLLECTION || !((CollectionQuerySpace)CollectionQuerySpace.class.cast(join.getLeftHandSide())).getCollectionPersister().isOneToMany()) {
                this.renderEntityJoin(join, joinFragment);
            }
        } else if (CollectionQuerySpace.class.isInstance(join.getRightHandSide())) {
            this.renderCollectionJoin(join, joinFragment);
        }
    }

    private void handleCompositeJoin(Join join, JoinFragment joinFragment) {
        String leftHandSideUid = join.getLeftHandSide().getUid();
        String rightHandSideUid = join.getRightHandSide().getUid();
        String leftHandSideTableAlias = this.aliasResolutionContext.resolveSqlTableAliasFromQuerySpaceUid(leftHandSideUid);
        if (leftHandSideTableAlias == null) {
            throw new IllegalStateException("QuerySpace with that UID was not yet registered in the AliasResolutionContext");
        }
        this.aliasResolutionContext.registerCompositeQuerySpaceUidResolution(rightHandSideUid, leftHandSideTableAlias);
    }

    private void renderEntityJoin(Join join, JoinFragment joinFragment) {
        String leftHandSideUid = join.getLeftHandSide().getUid();
        String leftHandSideTableAlias = this.aliasResolutionContext.resolveSqlTableAliasFromQuerySpaceUid(leftHandSideUid);
        if (leftHandSideTableAlias == null) {
            throw new IllegalStateException("QuerySpace with that UID was not yet registered in the AliasResolutionContext");
        }
        String[] aliasedLhsColumnNames = join.resolveAliasedLeftHandSideJoinConditionColumns(leftHandSideTableAlias);
        EntityQuerySpace rightHandSide = (EntityQuerySpace)join.getRightHandSide();
        EntityReferenceAliases aliases = this.aliasResolutionContext.resolveEntityReferenceAliases(rightHandSide.getUid());
        if (aliases == null) {
            aliases = this.aliasResolutionContext.generateEntityReferenceAliases(rightHandSide.getUid(), rightHandSide.getEntityPersister());
        }
        String[] rhsColumnNames = join.resolveNonAliasedRightHandSideJoinConditionColumns();
        String rhsTableAlias = aliases.getTableAlias();
        AssociationType associationType = join instanceof JoinDefinedByMetadata ? ((JoinDefinedByMetadata)join).getJoinedAssociationPropertyType() : null;
        String additionalJoinConditions = this.resolveAdditionalJoinCondition(rhsTableAlias, join.getAnyAdditionalJoinConditions(rhsTableAlias), (Joinable)((Object)rightHandSide.getEntityPersister()), associationType);
        Joinable joinable = (Joinable)((Object)rightHandSide.getEntityPersister());
        LoadQueryJoinAndFetchProcessor.addJoins(joinFragment, joinable, join.isRightHandSideRequired() ? JoinType.INNER_JOIN : JoinType.LEFT_OUTER_JOIN, aliases.getTableAlias(), rhsColumnNames, aliasedLhsColumnNames, additionalJoinConditions);
    }

    private String resolveAdditionalJoinCondition(String rhsTableAlias, String withClause, Joinable joinable, AssociationType associationType) {
        String filter;
        String string = filter = associationType != null ? associationType.getOnCondition(rhsTableAlias, this.factory, this.buildingParameters.getQueryInfluencers().getEnabledFilters()) : joinable.filterFragment(rhsTableAlias, this.buildingParameters.getQueryInfluencers().getEnabledFilters());
        if (StringHelper.isEmpty(withClause) && StringHelper.isEmpty(filter)) {
            return "";
        }
        if (StringHelper.isNotEmpty(withClause) && StringHelper.isNotEmpty(filter)) {
            return filter + " and " + withClause;
        }
        return StringHelper.isNotEmpty(filter) ? filter : withClause;
    }

    private static void addJoins(JoinFragment joinFragment, Joinable joinable, JoinType joinType, String rhsAlias, String[] rhsColumnNames, String[] aliasedLhsColumnNames, String additionalJoinConditions) {
        if (StringHelper.isEmpty(rhsAlias)) {
            throw new IllegalStateException("Join's RHS table alias cannot be empty");
        }
        joinFragment.addJoin(joinable.getTableName(), rhsAlias, aliasedLhsColumnNames, rhsColumnNames, joinType, additionalJoinConditions);
        joinFragment.addJoins(joinable.fromJoinFragment(rhsAlias, false, true), joinable.whereJoinFragment(rhsAlias, false, true));
    }

    private void renderCollectionJoin(Join join, JoinFragment joinFragment) {
        String leftHandSideUid = join.getLeftHandSide().getUid();
        String leftHandSideTableAlias = this.aliasResolutionContext.resolveSqlTableAliasFromQuerySpaceUid(leftHandSideUid);
        if (leftHandSideTableAlias == null) {
            throw new IllegalStateException("QuerySpace with that UID was not yet registered in the AliasResolutionContext");
        }
        String[] aliasedLhsColumnNames = join.resolveAliasedLeftHandSideJoinConditionColumns(leftHandSideTableAlias);
        CollectionQuerySpace rightHandSide = (CollectionQuerySpace)join.getRightHandSide();
        CollectionReferenceAliases aliases = this.aliasResolutionContext.generateCollectionReferenceAliases(rightHandSide.getUid(), rightHandSide.getCollectionPersister());
        if (rightHandSide.getCollectionPersister().isOneToMany() || rightHandSide.getCollectionPersister().isManyToMany()) {
            Join collectionElementJoin = null;
            Iterator<Join> i$ = rightHandSide.getJoins().iterator();
            while (i$.hasNext()) {
                Join collectionJoin;
                collectionElementJoin = collectionJoin = i$.next();
            }
            if (collectionElementJoin == null) {
                throw new IllegalStateException(String.format("Could not locate collection element join within collection join [%s : %s]", rightHandSide.getUid(), rightHandSide.getCollectionPersister()));
            }
            this.aliasResolutionContext.registerQuerySpaceAliases(collectionElementJoin.getRightHandSide().getUid(), new EntityReferenceAliasesImpl(aliases.getElementTableAlias(), aliases.getEntityElementColumnAliases()));
        }
        this.renderSqlJoinToCollectionTable(aliases, rightHandSide, aliasedLhsColumnNames, join, joinFragment);
    }

    private void renderSqlJoinToCollectionTable(CollectionReferenceAliases aliases, CollectionQuerySpace rightHandSide, String[] aliasedLhsColumnNames, Join join, JoinFragment joinFragment) {
        String collectionTableAlias = aliases.getCollectionTableAlias();
        CollectionPersister persister = rightHandSide.getCollectionPersister();
        QueryableCollection queryableCollection = (QueryableCollection)persister;
        String filterFragment = queryableCollection.filterFragment(collectionTableAlias, this.buildingParameters.getQueryInfluencers().getEnabledFilters());
        joinFragment.addJoin(queryableCollection.getTableName(), collectionTableAlias, aliasedLhsColumnNames, queryableCollection.getKeyColumnNames(), JoinType.LEFT_OUTER_JOIN, filterFragment);
        joinFragment.addJoins(queryableCollection.fromJoinFragment(collectionTableAlias, false, true), queryableCollection.whereJoinFragment(collectionTableAlias, false, true));
    }

    private void renderManyToManyJoin(CollectionReferenceAliases aliases, CollectionQuerySpace rightHandSide, Join join, JoinFragment joinFragment) {
        CollectionPersister persister = rightHandSide.getCollectionPersister();
        QueryableCollection queryableCollection = (QueryableCollection)persister;
        String collectionTableAlias = aliases.getCollectionTableAlias();
        String elementTableAlias = aliases.getElementTableAlias();
        if (StringHelper.isEmpty(collectionTableAlias)) {
            throw new IllegalStateException("Collection table alias cannot be empty");
        }
        if (StringHelper.isEmpty(elementTableAlias)) {
            throw new IllegalStateException("Collection element (many-to-many) table alias cannot be empty");
        }
        AssociationType associationType = join instanceof JoinDefinedByMetadata ? ((JoinDefinedByMetadata)join).getJoinedAssociationPropertyType() : null;
        String additionalJoinConditions = this.resolveAdditionalJoinCondition(elementTableAlias, join.getAnyAdditionalJoinConditions(elementTableAlias), queryableCollection, associationType);
        String manyToManyFilter = persister.getManyToManyFilterFragment(elementTableAlias, this.buildingParameters.getQueryInfluencers().getEnabledFilters());
        String condition = StringHelper.isEmpty(manyToManyFilter) ? additionalJoinConditions : (StringHelper.isEmpty(additionalJoinConditions) ? manyToManyFilter : additionalJoinConditions + " and " + manyToManyFilter);
        OuterJoinLoadable elementPersister = (OuterJoinLoadable)queryableCollection.getElementPersister();
        LoadQueryJoinAndFetchProcessor.addJoins(joinFragment, elementPersister, JoinType.LEFT_OUTER_JOIN, elementTableAlias, elementPersister.getIdentifierColumnNames(), StringHelper.qualify(collectionTableAlias, queryableCollection.getElementColumnNames()), condition);
    }

    public FetchStats processFetches(FetchSource fetchSource, SelectStatementBuilder selectStatementBuilder, ReaderCollector readerCollector) {
        EntityReference fetchOwnerAsEntityReference;
        FetchStatsImpl fetchStats = new FetchStatsImpl();
        if (EntityReference.class.isInstance(fetchSource) && (fetchOwnerAsEntityReference = (EntityReference)fetchSource).getIdentifierDescription().hasFetches()) {
            FetchSource entityIdentifierAsFetchSource = (FetchSource)((Object)fetchOwnerAsEntityReference.getIdentifierDescription());
            for (Fetch fetch : entityIdentifierAsFetchSource.getFetches()) {
                this.processFetch(selectStatementBuilder, fetchSource, fetch, readerCollector, fetchStats);
            }
        }
        this.processFetches(fetchSource, selectStatementBuilder, readerCollector, fetchStats);
        return fetchStats;
    }

    private void processFetches(FetchSource fetchSource, SelectStatementBuilder selectStatementBuilder, ReaderCollector readerCollector, FetchStatsImpl fetchStats) {
        for (Fetch fetch : fetchSource.getFetches()) {
            this.processFetch(selectStatementBuilder, fetchSource, fetch, readerCollector, fetchStats);
        }
    }

    private void processFetch(SelectStatementBuilder selectStatementBuilder, FetchSource fetchSource, Fetch fetch, ReaderCollector readerCollector, FetchStatsImpl fetchStats) {
        if (!FetchStrategyHelper.isJoinFetched(fetch.getFetchStrategy())) {
            return;
        }
        if (EntityFetch.class.isInstance(fetch)) {
            EntityFetch entityFetch = (EntityFetch)fetch;
            this.processEntityFetch(selectStatementBuilder, fetchSource, entityFetch, readerCollector, fetchStats);
        } else if (CollectionFetch.class.isInstance(fetch)) {
            CollectionFetch collectionFetch = (CollectionFetch)fetch;
            this.processCollectionFetch(selectStatementBuilder, fetchSource, collectionFetch, readerCollector, fetchStats);
        } else if (FetchSource.class.isInstance(fetch)) {
            this.processFetches((FetchSource)((Object)fetch), selectStatementBuilder, readerCollector, fetchStats);
        }
    }

    private void processEntityFetch(SelectStatementBuilder selectStatementBuilder, FetchSource fetchSource, EntityFetch fetch, ReaderCollector readerCollector, FetchStatsImpl fetchStats) {
        fetchStats.processingFetch(fetch);
        Joinable joinable = (Joinable)((Object)fetch.getEntityPersister());
        EntityReferenceAliases aliases = this.aliasResolutionContext.resolveEntityReferenceAliases(fetch.getQuerySpaceUid());
        selectStatementBuilder.appendSelectClauseFragment(joinable.selectFragment(null, null, aliases.getTableAlias(), aliases.getColumnAliases().getSuffix(), null, true));
        readerCollector.add(new EntityReferenceInitializerImpl(fetch, aliases));
        this.processFetches(fetch, selectStatementBuilder, readerCollector, fetchStats);
    }

    private void processCollectionFetch(SelectStatementBuilder selectStatementBuilder, FetchSource fetchSource, CollectionFetch fetch, ReaderCollector readerCollector, FetchStatsImpl fetchStats) {
        fetchStats.processingFetch(fetch);
        final CollectionReferenceAliases aliases = this.aliasResolutionContext.resolveCollectionReferenceAliases(fetch.getQuerySpaceUid());
        QueryableCollection queryableCollection = (QueryableCollection)fetch.getCollectionPersister();
        Joinable joinableCollection = (Joinable)((Object)fetch.getCollectionPersister());
        if (fetch.getCollectionPersister().isManyToMany()) {
            String ordering;
            String ownerTableAlias = this.aliasResolutionContext.resolveSqlTableAliasFromQuerySpaceUid(fetchSource.getQuerySpaceUid());
            String collectionTableAlias = aliases.getCollectionTableAlias();
            String elementTableAlias = aliases.getElementTableAlias();
            selectStatementBuilder.appendSelectClauseFragment(joinableCollection.selectFragment((Joinable)((Object)queryableCollection.getElementPersister()), elementTableAlias, collectionTableAlias, aliases.getEntityElementColumnAliases().getSuffix(), aliases.getCollectionColumnAliases().getSuffix(), true));
            OuterJoinLoadable elementPersister = (OuterJoinLoadable)queryableCollection.getElementPersister();
            selectStatementBuilder.appendSelectClauseFragment(elementPersister.selectFragment(elementTableAlias, aliases.getEntityElementColumnAliases().getSuffix()));
            String manyToManyOrdering = queryableCollection.getManyToManyOrderByString(collectionTableAlias);
            if (StringHelper.isNotEmpty(manyToManyOrdering)) {
                selectStatementBuilder.appendOrderByFragment(manyToManyOrdering);
            }
            if (StringHelper.isNotEmpty(ordering = queryableCollection.getSQLOrderByString(collectionTableAlias))) {
                selectStatementBuilder.appendOrderByFragment(ordering);
            }
            EntityReferenceAliases entityReferenceAliases = new EntityReferenceAliases(){

                @Override
                public String getTableAlias() {
                    return aliases.getCollectionTableAlias();
                }

                @Override
                public EntityAliases getColumnAliases() {
                    return aliases.getEntityElementColumnAliases();
                }
            };
            this.aliasResolutionContext.registerQuerySpaceAliases(fetch.getQuerySpaceUid(), entityReferenceAliases);
            readerCollector.add(new EntityReferenceInitializerImpl((EntityReference)((Object)fetch.getElementGraph()), entityReferenceAliases));
        } else {
            String ordering;
            String rhsTableAlias = aliases.getElementTableAlias();
            selectStatementBuilder.appendSelectClauseFragment(queryableCollection.selectFragment(rhsTableAlias, aliases.getCollectionColumnAliases().getSuffix()));
            if (fetch.getCollectionPersister().isOneToMany()) {
                OuterJoinLoadable elementPersister = (OuterJoinLoadable)queryableCollection.getElementPersister();
                selectStatementBuilder.appendSelectClauseFragment(elementPersister.selectFragment(aliases.getElementTableAlias(), aliases.getEntityElementColumnAliases().getSuffix()));
                EntityReferenceAliases entityReferenceAliases = new EntityReferenceAliases(){

                    @Override
                    public String getTableAlias() {
                        return aliases.getElementTableAlias();
                    }

                    @Override
                    public EntityAliases getColumnAliases() {
                        return aliases.getEntityElementColumnAliases();
                    }
                };
                this.aliasResolutionContext.registerQuerySpaceAliases(fetch.getQuerySpaceUid(), entityReferenceAliases);
                readerCollector.add(new EntityReferenceInitializerImpl((EntityReference)((Object)fetch.getElementGraph()), entityReferenceAliases));
            }
            if (StringHelper.isNotEmpty(ordering = queryableCollection.getSQLOrderByString(rhsTableAlias))) {
                selectStatementBuilder.appendOrderByFragment(ordering);
            }
        }
        if (fetch.getElementGraph() != null) {
            this.processFetches(fetch.getElementGraph(), selectStatementBuilder, readerCollector);
        }
        readerCollector.add(new CollectionReferenceInitializerImpl(fetch, aliases));
    }

    private static class FetchStatsImpl
    implements FetchStats {
        private boolean hasSubselectFetch;

        private FetchStatsImpl() {
        }

        public void processingFetch(Fetch fetch) {
            if (!this.hasSubselectFetch && fetch.getFetchStrategy().getStyle() == FetchStyle.SUBSELECT && fetch.getFetchStrategy().getTiming() != FetchTiming.IMMEDIATE) {
                this.hasSubselectFetch = true;
            }
        }

        @Override
        public boolean hasSubselectFetches() {
            return this.hasSubselectFetch;
        }
    }
}

