/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan2.build.internal.spaces.CollectionQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.EntityQuerySpaceImpl;
import org.hibernate.loader.plan2.build.spi.ExpandingEntityQuerySpace;
import org.hibernate.loader.plan2.build.spi.ExpandingQuerySpaces;
import org.hibernate.loader.plan2.spi.CollectionQuerySpace;
import org.hibernate.loader.plan2.spi.QuerySpace;
import org.hibernate.loader.plan2.spi.QuerySpaceUidNotRegisteredException;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class QuerySpacesImpl
implements ExpandingQuerySpaces {
    private static final Logger log = CoreLogging.logger(QuerySpacesImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final List<QuerySpace> roots = new ArrayList<QuerySpace>();
    private final Map<String, QuerySpace> querySpaceByUid = new ConcurrentHashMap<String, QuerySpace>();
    private int implicitUidBase = 0;

    public QuerySpacesImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<QuerySpace> getRootQuerySpaces() {
        return this.roots;
    }

    @Override
    public QuerySpace findQuerySpaceByUid(String uid) {
        return this.querySpaceByUid.get(uid);
    }

    @Override
    public QuerySpace getQuerySpaceByUid(String uid) {
        QuerySpace space = this.findQuerySpaceByUid(uid);
        if (space == null) {
            throw new QuerySpaceUidNotRegisteredException(uid);
        }
        return space;
    }

    @Override
    public String generateImplicitUid() {
        return "<gen:" + this.implicitUidBase++ + ">";
    }

    @Override
    public ExpandingEntityQuerySpace makeEntityQuerySpace(String uid, EntityPersister entityPersister) {
        if (this.querySpaceByUid.containsKey(uid)) {
            throw new IllegalStateException("Encountered duplicate QuerySpace uid : " + uid);
        }
        EntityQuerySpaceImpl space = new EntityQuerySpaceImpl(entityPersister, uid, this, true, this.sessionFactory);
        this.registerQuerySpace(space);
        this.roots.add(space);
        return space;
    }

    @Override
    public CollectionQuerySpace makeCollectionQuerySpace(String uid, CollectionPersister collectionPersister) {
        if (this.querySpaceByUid.containsKey(uid)) {
            throw new IllegalStateException("Encountered duplicate QuerySpace uid : " + uid);
        }
        CollectionQuerySpaceImpl space = new CollectionQuerySpaceImpl(collectionPersister, uid, this, true, this.sessionFactory);
        this.registerQuerySpace(space);
        this.roots.add(space);
        return space;
    }

    public void registerQuerySpace(QuerySpace querySpace) {
        log.debugf("Adding QuerySpace : uid = %s -> %s]", (Object)querySpace.getUid(), (Object)querySpace);
        QuerySpace previous = this.querySpaceByUid.put(querySpace.getUid(), querySpace);
        if (previous != null) {
            throw new IllegalStateException("Encountered duplicate QuerySpace uid : " + querySpace.getUid());
        }
    }
}

