/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.spaces;

import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.plan2.spi.JoinDefinedByMetadata;
import org.hibernate.loader.plan2.spi.QuerySpace;
import org.hibernate.type.AssociationType;

public class JoinImpl
implements JoinDefinedByMetadata {
    private final QuerySpace leftHandSide;
    private final QuerySpace rightHandSide;
    private final String lhsPropertyName;
    private final String[] rhsColumnNames;
    private final boolean rightHandSideOptional;
    private final AssociationType joinedAssociationPropertyType;

    public JoinImpl(QuerySpace leftHandSide, String lhsPropertyName, QuerySpace rightHandSide, String[] rhsColumnNames, AssociationType attributeType, boolean rightHandSideOptional) {
        this.leftHandSide = leftHandSide;
        this.lhsPropertyName = lhsPropertyName;
        this.rightHandSide = rightHandSide;
        this.rhsColumnNames = rhsColumnNames;
        this.rightHandSideOptional = rightHandSideOptional;
        this.joinedAssociationPropertyType = attributeType;
        if (StringHelper.isEmpty(lhsPropertyName)) {
            throw new IllegalArgumentException("Incoming 'lhsPropertyName' parameter was empty");
        }
    }

    @Override
    public QuerySpace getLeftHandSide() {
        return this.leftHandSide;
    }

    @Override
    public QuerySpace getRightHandSide() {
        return this.rightHandSide;
    }

    @Override
    public boolean isRightHandSideRequired() {
        return this.rightHandSideOptional;
    }

    @Override
    public String[] resolveAliasedLeftHandSideJoinConditionColumns(String leftHandSideTableAlias) {
        return this.getLeftHandSide().getPropertyMapping().toColumns(leftHandSideTableAlias, this.getJoinedAssociationPropertyName());
    }

    @Override
    public String[] resolveNonAliasedRightHandSideJoinConditionColumns() {
        if (this.rhsColumnNames == null) {
            throw new IllegalStateException("rhsColumnNames were null.  Generally that indicates a composite join, in which case calls to resolveAliasedLeftHandSideJoinConditionColumns are not allowed");
        }
        return this.rhsColumnNames;
    }

    @Override
    public String getAnyAdditionalJoinConditions(String rhsTableAlias) {
        return null;
    }

    @Override
    public String getJoinedAssociationPropertyName() {
        return this.lhsPropertyName;
    }

    @Override
    public AssociationType getJoinedAssociationPropertyType() {
        return this.joinedAssociationPropertyType;
    }
}

