/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.returns;

import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan2.build.internal.returns.AbstractExpandingFetchSource;
import org.hibernate.loader.plan2.build.internal.returns.CompositeFetchImpl;
import org.hibernate.loader.plan2.build.internal.returns.EncapsulatedEntityIdentifierDescription;
import org.hibernate.loader.plan2.build.internal.returns.NonEncapsulatedEntityIdentifierDescription;
import org.hibernate.loader.plan2.build.internal.returns.SimpleEntityIdentifierDescriptionImpl;
import org.hibernate.loader.plan2.build.spi.ExpandingCompositeQuerySpace;
import org.hibernate.loader.plan2.build.spi.ExpandingEntityQuerySpace;
import org.hibernate.loader.plan2.spi.CompositeFetch;
import org.hibernate.loader.plan2.spi.EntityIdentifierDescription;
import org.hibernate.loader.plan2.spi.EntityReference;
import org.hibernate.loader.plan2.spi.Join;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.EncapsulatedEntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.EntityIdentifierDefinition;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public abstract class AbstractEntityReference
extends AbstractExpandingFetchSource
implements EntityReference {
    private final EntityIdentifierDescription identifierDescription = this.buildIdentifierDescription();

    public AbstractEntityReference(ExpandingEntityQuerySpace entityQuerySpace, PropertyPath propertyPath) {
        super(entityQuerySpace, propertyPath);
    }

    private ExpandingEntityQuerySpace expandingEntityQuerySpace() {
        return (ExpandingEntityQuerySpace)this.expandingQuerySpace();
    }

    private EntityIdentifierDescription buildIdentifierDescription() {
        EncapsulatedEntityIdentifierDefinition encapsulatedIdentifierDefinition;
        Type idAttributeType;
        EntityIdentifierDefinition identifierDefinition = this.getEntityPersister().getEntityKeyDefinition();
        if (identifierDefinition.isEncapsulated() && !CompositeType.class.isInstance(idAttributeType = (encapsulatedIdentifierDefinition = (EncapsulatedEntityIdentifierDefinition)identifierDefinition).getAttributeDefinition().getType())) {
            return new SimpleEntityIdentifierDescriptionImpl();
        }
        Join join = this.expandingEntityQuerySpace().makeCompositeIdentifierJoin();
        return identifierDefinition.isEncapsulated() ? this.buildEncapsulatedCompositeIdentifierDescription(join) : this.buildNonEncapsulatedCompositeIdentifierDescription(join);
    }

    private NonEncapsulatedEntityIdentifierDescription buildNonEncapsulatedCompositeIdentifierDescription(Join compositeJoin) {
        return new NonEncapsulatedEntityIdentifierDescription(this, (ExpandingCompositeQuerySpace)compositeJoin.getRightHandSide(), (CompositeType)this.getEntityPersister().getIdentifierType(), this.getPropertyPath().append("id"));
    }

    private EncapsulatedEntityIdentifierDescription buildEncapsulatedCompositeIdentifierDescription(Join compositeJoin) {
        return new EncapsulatedEntityIdentifierDescription(this, (ExpandingCompositeQuerySpace)compositeJoin.getRightHandSide(), (CompositeType)this.getEntityPersister().getIdentifierType(), this.getPropertyPath().append("id"));
    }

    @Override
    public EntityReference resolveEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.expandingEntityQuerySpace().getEntityPersister();
    }

    @Override
    public EntityIdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    protected CompositeFetch createCompositeFetch(CompositeType compositeType, ExpandingCompositeQuerySpace compositeQuerySpace) {
        return new CompositeFetchImpl(this, compositeType, compositeQuerySpace, true, this.getPropertyPath());
    }
}

