/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.CopyableReturn;
import org.hibernate.loader.plan.spi.EntityPersisterBasedSqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.SqlSelectFragmentResolver;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.walking.spi.AttributeDefinition;

public class EntityReturn
extends AbstractFetchOwner
implements Return,
EntityReference,
CopyableReturn {
    private final EntityPersister persister;
    private final EntityPersisterBasedSqlSelectFragmentResolver sqlSelectFragmentResolver;
    private IdentifierDescription identifierDescription;
    private final PropertyPath propertyPath;
    private final LockMode lockMode;

    public EntityReturn(SessionFactoryImplementor sessionFactory, LockMode lockMode, String entityName) {
        super(sessionFactory);
        this.persister = sessionFactory.getEntityPersister(entityName);
        this.propertyPath = new PropertyPath(entityName);
        this.sqlSelectFragmentResolver = new EntityPersisterBasedSqlSelectFragmentResolver((Queryable)this.persister);
        this.lockMode = lockMode;
    }

    protected EntityReturn(EntityReturn original, CopyContext copyContext) {
        super(original, copyContext);
        this.persister = original.persister;
        this.propertyPath = original.propertyPath;
        this.sqlSelectFragmentResolver = original.sqlSelectFragmentResolver;
        this.lockMode = original.lockMode;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy, AttributeDefinition attributeDefinition) {
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.getEntityPersister();
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    public String toString() {
        return "EntityReturn(" + this.persister.getEntityName() + ")";
    }

    @Override
    public EntityReturn makeCopy(CopyContext copyContext) {
        return new EntityReturn(this, copyContext);
    }

    @Override
    public SqlSelectFragmentResolver toSqlSelectFragmentResolver() {
        return this.sqlSelectFragmentResolver;
    }
}

