/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.spi.AbstractSingularAttributeFetch;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityPersisterBasedSqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.SqlSelectFragmentResolver;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.EntityType;

public class EntityFetch
extends AbstractSingularAttributeFetch
implements EntityReference,
Fetch {
    private final EntityPersister persister;
    private final EntityPersisterBasedSqlSelectFragmentResolver sqlSelectFragmentResolver;
    private IdentifierDescription identifierDescription;
    private final LockMode lockMode;

    public EntityFetch(SessionFactoryImplementor sessionFactory, LockMode lockMode, FetchOwner owner, AttributeDefinition fetchedAttribute, FetchStrategy fetchStrategy) {
        super(sessionFactory, owner, fetchedAttribute, fetchStrategy);
        this.persister = sessionFactory.getEntityPersister(this.getFetchedType().getAssociatedEntityName());
        if (this.persister == null) {
            throw new WalkingException(String.format("Unable to locate EntityPersister [%s] for fetch [%s]", this.getFetchedType().getAssociatedEntityName(), fetchedAttribute.getName()));
        }
        this.sqlSelectFragmentResolver = new EntityPersisterBasedSqlSelectFragmentResolver((Queryable)this.persister);
        this.lockMode = lockMode;
    }

    protected EntityFetch(EntityFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext, fetchOwnerCopy);
        this.persister = original.persister;
        this.sqlSelectFragmentResolver = original.sqlSelectFragmentResolver;
        this.lockMode = original.lockMode;
    }

    @Override
    public EntityType getFetchedType() {
        return (EntityType)super.getFetchedType();
    }

    @Override
    public String[] toSqlSelectFragments(String alias) {
        return this.getOwner().toSqlSelectFragmentResolver().toSqlSelectFragments(alias, this.getFetchedAttribute());
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    @Override
    public SqlSelectFragmentResolver toSqlSelectFragmentResolver() {
        return this.sqlSelectFragmentResolver;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.persister;
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    @Override
    public String toString() {
        return "EntityFetch(" + this.getPropertyPath().getFullPath() + " -> " + this.persister.getEntityName() + ")";
    }

    @Override
    public EntityFetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        copyContext.getReturnGraphVisitationStrategy().startingEntityFetch(this);
        EntityFetch copy = new EntityFetch(this, copyContext, fetchOwnerCopy);
        copyContext.getReturnGraphVisitationStrategy().finishingEntityFetch(this);
        return copy;
    }
}

