/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.spi.AbstractSingularAttributeFetch;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CompositeBasedSqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.SqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.type.CompositeType;

public class CompositeFetch
extends AbstractSingularAttributeFetch {
    private static final FetchStrategy FETCH_PLAN = new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.JOIN);
    private final CompositeBasedSqlSelectFragmentResolver sqlSelectFragmentResolver;

    public CompositeFetch(SessionFactoryImplementor sessionFactory, final FetchOwner owner, final AttributeDefinition fetchedAttribute) {
        super(sessionFactory, owner, fetchedAttribute, FETCH_PLAN);
        this.sqlSelectFragmentResolver = new CompositeBasedSqlSelectFragmentResolver(sessionFactory, (CompositeType)fetchedAttribute.getType(), new CompositeBasedSqlSelectFragmentResolver.BaseSqlSelectFragmentResolver(){

            @Override
            public String[] toSqlSelectFragments(String alias) {
                return owner.toSqlSelectFragmentResolver().toSqlSelectFragments(alias, fetchedAttribute);
            }
        });
    }

    public CompositeFetch(CompositeFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext, fetchOwnerCopy);
        this.sqlSelectFragmentResolver = original.sqlSelectFragmentResolver;
    }

    @Override
    public SqlSelectFragmentResolver toSqlSelectFragmentResolver() {
        return this.sqlSelectFragmentResolver;
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.getOwner().retrieveFetchSourcePersister();
    }

    @Override
    public CompositeFetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        copyContext.getReturnGraphVisitationStrategy().startingCompositeFetch(this);
        CompositeFetch copy = new CompositeFetch(this, copyContext, fetchOwnerCopy);
        copyContext.getReturnGraphVisitationStrategy().finishingCompositeFetch(this);
        return copy;
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return new CollectionFetch(loadPlanBuildingContext.getSessionFactory(), LockMode.NONE, this, fetchStrategy, attributeDefinition);
    }
}

