/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.BidirectionalEntityFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CompositeElementGraph;
import org.hibernate.loader.plan.spi.CompositeIndexGraph;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityElementGraph;
import org.hibernate.loader.plan.spi.EntityIndexGraph;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.FetchableCollectionElement;
import org.hibernate.loader.plan.spi.FetchableCollectionIndex;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public abstract class AbstractCollectionReference
extends AbstractPlanNode
implements CollectionReference {
    private final LockMode lockMode;
    private final CollectionPersister collectionPersister;
    private final PropertyPath propertyPath;
    private final FetchableCollectionIndex indexGraph;
    private final FetchableCollectionElement elementGraph;

    protected AbstractCollectionReference(SessionFactoryImplementor sessionFactory, LockMode lockMode, CollectionPersister collectionPersister, PropertyPath propertyPath, EntityReference ownerEntityReference) {
        super(sessionFactory);
        this.lockMode = lockMode;
        this.collectionPersister = collectionPersister;
        this.propertyPath = propertyPath;
        this.indexGraph = this.buildIndexGraph(this.getCollectionPersister());
        this.elementGraph = this.buildElementGraph(this.getCollectionPersister(), ownerEntityReference);
    }

    private FetchableCollectionIndex buildIndexGraph(CollectionPersister persister) {
        if (persister.hasIndex()) {
            Type type = persister.getIndexType();
            if (type.isAssociationType()) {
                if (type.isEntityType()) {
                    return new EntityIndexGraph(this.sessionFactory(), this, this.getPropertyPath());
                }
            } else if (type.isComponentType()) {
                return new CompositeIndexGraph(this.sessionFactory(), this, this.getPropertyPath());
            }
        }
        return null;
    }

    private FetchableCollectionElement buildElementGraph(CollectionPersister persister, EntityReference ownerEntityReference) {
        Type type = persister.getElementType();
        if (type.isAssociationType()) {
            if (type.isEntityType()) {
                boolean sameType;
                EntityType elementEntityType = (EntityType)type;
                if (ownerEntityReference != null && (sameType = elementEntityType.getAssociatedEntityName().equals(ownerEntityReference.getEntityPersister().getEntityName()))) {
                    return new BidirectionalEntityElementGraph(this.sessionFactory(), this, this.getPropertyPath(), ownerEntityReference);
                }
                return new EntityElementGraph(this.sessionFactory(), this, this.getPropertyPath());
            }
        } else if (type.isComponentType()) {
            return new CompositeElementGraph(this.sessionFactory(), this, this.getPropertyPath());
        }
        return null;
    }

    protected AbstractCollectionReference(AbstractCollectionReference original, CopyContext copyContext) {
        super(original);
        this.lockMode = original.lockMode;
        this.collectionPersister = original.collectionPersister;
        this.propertyPath = original.propertyPath;
        this.indexGraph = original.indexGraph == null ? null : original.indexGraph.makeCopy(copyContext);
        this.elementGraph = original.elementGraph == null ? null : original.elementGraph.makeCopy(copyContext);
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    @Override
    public FetchOwner getIndexGraph() {
        return this.indexGraph;
    }

    @Override
    public FetchOwner getElementGraph() {
        return this.elementGraph;
    }

    private class BidirectionalEntityElementGraph
    extends EntityElementGraph
    implements BidirectionalEntityFetch {
        private final EntityReference targetEntityReference;

        private BidirectionalEntityElementGraph(SessionFactoryImplementor sessionFactory, CollectionReference collectionReference, PropertyPath propertyPath, EntityReference targetEntityReference) {
            super(sessionFactory, collectionReference, propertyPath);
            this.targetEntityReference = targetEntityReference;
        }

        @Override
        public EntityReference getTargetEntityReference() {
            return this.targetEntityReference;
        }
    }
}

